/*
 * Copyright (C) 2020-2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <QCoreApplication>

#include "officeworker.h"

OfficeWorker *s_worker = nullptr;

void myMessageOutput(QtMsgType type, const QMessageLogContext &context, const QString &msg)
{
    Q_UNUSED(context)
    switch (type) {
    case QtDebugMsg:
    case QtInfoMsg:
    case QtWarningMsg:
    case QtCriticalMsg:
        s_worker->sendDebug(msg);
        break;
    case QtFatalMsg:
        s_worker->sendDebug(msg);
        abort();
    }
}

int main(int argc, char *argv[])
{    
    QCoreApplication app(argc, argv);

    OfficeWorker worker(argv[2]);
    s_worker = &worker;
    qInstallMessageHandler(myMessageOutput); // Install the handler

    worker.loadDocument(argv[1]);

    return app.exec();
}
