/*
 * Copyright (c) 2021 - 2023 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#pragma once

#include "documentproviderglobal.h"
#include <atomic>
#include <QFileInfo>
#include <QImage>
#include <QMap>
#include <QMutex>
#include <QObject>
#include <QThreadPool>

class ImagesCache;
class ExportedCache;

class DOCUMENTPROVIDER_EXPORT DocumentCache : public QObject
{
    Q_OBJECT

public:
    ~DocumentCache();

    /// @note Zoom and tile rect are not counted for page image
    bool loadImage(const QString &fileId, int pageNumber, const QSize &canvasSize, const QRect &rectTile = QRect(), qreal zoom = 1.0);
    /// @note Zoom and tile rect are not counted for page image
    void insertImage(const QString &fileId, int pageNumber, const QImage &image, const QRect &rectTile = QRect(), qreal zoom = 1.0);

    bool loadExportedDoc(const QString &fileId, const QString &pathExportedDoc, const QString &format = "pdf");
    void insertEportedDoc(const QString &fileId, const QString &pathExportedDoc, const QString &format = "pdf");

    void calculateChecksum(const QString &filePath);

    static DocumentCache *instance();

signals:
    void imageLoaded(const QString &fileId, int pageNumber, const QImage &image, const QRect &rectTile, qreal zoom);
    void documentExported(const QString &pathExportedDoc, const QString format, bool status);
    void checksumCalculated(const QString &filePath, const QByteArray &checksum);

private:
    DocumentCache(QObject *parent = nullptr);

private:
    ImagesCache *m_pageCache;
    ImagesCache *m_tileCache;
    ExportedCache *m_exportedCache;
};
