/*
 * Copyright (c) 2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#pragma once

#include <QObject>
#include <QSizeF>
#include <QFuture>
#include <QPointF>
#include "basedocument.h"
#include "documentproviderglobal.h"

class BaseAnnotation;
class DOCUMENTPROVIDER_EXPORT BasePage : public QObject
{
    Q_OBJECT

public:
    explicit BasePage(QObject *parent = nullptr);
    virtual ~BasePage();

    virtual QThreadPool *threadPool() const = 0;
    virtual QList<BaseAnnotation *> annotations() const = 0;
    virtual void loadAnnotations() = 0;
    virtual bool isAnnotationsSupport() const = 0;
    virtual int pageIndex() const = 0;
    virtual QFuture<QSizeF> originalSize() = 0;
    virtual QFuture<QImage> bitmapFull(qreal pageScale, int renderFlags = 0) const = 0;
    virtual QFuture<QImage> bitmapPart(qreal pageScaleX, qreal pageScaleY,
                                       int renderFlags = 0, qreal zoom = 1.0,
                                       const QPointF &bias = QPointF(),
                                       qreal pageScale = 1.0) const = 0;
    virtual void addAnnotation(const QRectF &rect, const QColor &color,
                                       const QString &author, const QString &content) = 0;
    virtual void stopBitmapPart(qreal pageScaleX, qreal pageScaleY, qreal zoom = 1.0,
                                const QPointF &bias = QPointF()) = 0;
    virtual void stopAllBitmapPart() = 0;
    virtual BaseDocumentProvider::DocumentType documentType() const = 0;

signals:
    void annotationsLoaded();
    void originalSizeLoaded();
    void annotationsChanged();
    void annotationAdded(bool);
    void annotationDelete(int, bool);
    void invalidateRect(const QRectF &rect);
};
