/*
 * Copyright (c) 2022 - 2023 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#include <QMetaType>

#include "basedocument.h"

BaseDocument::BaseDocument(QObject *parent)
    : QObject(parent)
    , m_loadingProgress(0)
    , m_pageIndex(-1)
    , m_mode(Mode::ModeView)
{
    qRegisterMetaType<PageLoadStatus>();
}

BaseDocument::~BaseDocument() = default;

BaseDocument::DocumentStatus BaseDocument::status() const
{
    return m_status;
}

QString BaseDocument::path() const
{
    return m_path;
}

bool BaseDocument::processing() const
{
    return m_processing;
}

int BaseDocument::loadingProgress() const
{
    return m_loadingProgress;
}

void BaseDocument::setLoadingProgress(int loadingProgress)
{
    if (m_loadingProgress == loadingProgress)
        return;

    m_loadingProgress = loadingProgress;
    emit loadingProgressChanged(m_loadingProgress);
}

void BaseDocument::setProcessing(bool processing)
{
    if (m_processing == processing)
        return;

    m_processing = processing;
    emit processingChanged(m_processing);
}

int BaseDocument::pageIndex() const
{
    return m_pageIndex;
}

void BaseDocument::setPageIndex(int newPageIndex)
{
    if (m_pageIndex == newPageIndex)
        return;
    m_pageIndex = newPageIndex;
    emit pageIndexChanged(m_pageIndex);
}

BaseDocument::Mode BaseDocument::mode() const
{
    return m_mode;
}

void BaseDocument::setMode(Mode newMode)
{
    if (m_mode == newMode)
        return;
    m_mode = newMode;
    emit modeChanged();
}
