/*
 * Copyright (c) 2022 - 2023 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#pragma once

#include <QRectF>
#include <QString>

struct BaseAnnotation
{
public:
    enum class AnnotationType
    {
        Link,
        Url,
        HighLight,
        Comment,
        CurrentSearch,
        AllSearch,
        CellSelected,
        TextSelected
    };

    AnnotationType type;
    QRectF rect;
    QString author;
    QString content;
    QString dateTime;
    int linkToPage;
    QPointF pageCoordinate;
};
