/*
 * Copyright (C) 2013-2014 Jolla Ltd.
 * Contact: Robin Burchell <robin.burchell@jolla.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef TRACKERDOCUMENTPROVIDER_H
#define TRACKERDOCUMENTPROVIDER_H

#include "documentprovider.h"

#include <QtCore/QFileInfo>
#include <QtCore/QHash>
#include <QtCore/QRunnable>
#include <QtQml/QQmlParserStatus>
#include <QMimeDatabase>

class DocumentListModel;
class TrackerDocumentProvider : public DocumentProvider, public QQmlParserStatus
{
    Q_OBJECT
    Q_INTERFACES(DocumentProvider QQmlParserStatus)

public:
    enum DocumentType
    {
        TextDocumentType,
        SpreadsheetType,
        PresentationType
    };
    TrackerDocumentProvider(QObject *parent = 0);
    ~TrackerDocumentProvider();
    int count() const override;
    QUrl icon() const override;
    QString title() const override;
    QString description() const override;
    QObject *model() const override;
    QUrl thumbnail() const override;
    bool isReady() const override;

    void classBegin() override;
    void componentComplete() override;

    void deleteFile(const QUrl &file) override;

    Q_INVOKABLE bool isPdf(const QString &url) const;

public Q_SLOTS:
    void startSearch();
    void stopSearch();

private Q_SLOTS:
    void searchFinished();
    void trackerGraphChanged(const QString &graphName);

private:
    class Private;
    Private *d;
    QString getMimeType( QString filePath );
    int getFileSize( QString filePath );
};

#endif // TRACKERDOCUMENTPROVIDER_H
