/*******************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
** Contact: https://community.omprussia.ru/open-source

**
** This file is part of the DocumentConverter project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/

#include <auroraapp.h>
#include <QtQuick>
#include <QMetaType>
#include <QDir>
#include <QGuiApplication>
#include <QQmlEngine>
#include <QQuickView>
#include <QTranslator>
#include <QLoggingCategory>

#include "converter.h"
#include "documentlistmodel.h"
#include "documentprovider.h"
#include "filtermodel.h"
#include "trackerdocumentprovider.h"
#include "licensestatus.h"

int main(int argc, char *argv[])
{
    QGuiApplication app(argc, argv);
    QCoreApplication::setAttribute(Qt::AA_EnableHighDpiScaling);

    app.setOrganizationName(QStringLiteral("ru.auroraos"));
    app.setApplicationName(QStringLiteral("OfficeViewer"));

    QDir dir(QStringLiteral("/usr/share/translations"));

    QScopedPointer<QTranslator> engineeringEnglish(new QTranslator);
    engineeringEnglish->load(QStringLiteral("docviewer_eng_en"), dir.absolutePath());

    QScopedPointer<QTranslator> translator(new QTranslator);
    translator->load(QLocale(), QStringLiteral("docviewer"), "-", dir.absolutePath());

    app.installTranslator(engineeringEnglish.data());
    app.installTranslator(translator.data());

    qmlRegisterType<DocumentListModel>("Aurora.Office.Files", 1, 0, "DocumentListModel");
    qmlRegisterType<FilterModel>("Aurora.Office.Files", 1, 0, "FilterModel");
    qmlRegisterType<TrackerDocumentProvider>("Aurora.Office.Files", 1, 0, "TrackerDocumentProvider");
    qmlRegisterType<LicenseStatus>("Aurora.Office.License", 1, 0, "LicenseStatus");

    QScopedPointer<QQuickView> view(Aurora::Application::createView());
    view->setSource(Aurora::Application::pathTo(QStringLiteral("qml/OfficeViewer.qml")));

    app.connect(view->engine(), &QQmlEngine::quit, &app, &QCoreApplication::quit);

    bool prestart = argc > 1 && strncmp(argv[1], "-prestart", 9) == 0;
    if (!prestart)
        view->showFullScreen();

    return app.exec();
}
