/**
 * SPDX-FileCopyrightText: Copyright 2019 - 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: GPLv2
 */

 /*
 * Copyright (C) 2013-2014 Jolla Ltd.
 * Contact: Robin Burchell <robin.burchell@jolla.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

#ifndef DOCUMENTLISTMODEL_H
#define DOCUMENTLISTMODEL_H

#include <QAbstractListModel>
#include <qdatetime.h>

class DocumentListModelPrivate;

class DocumentListModel : public QAbstractListModel
{
    Q_OBJECT

    Q_PROPERTY(int rowCount READ rowCount NOTIFY rowCountChanged)

public:
    enum DocumentClass
    {
        UnknownDocument,
        TextDocument,
        PlainTextDocument,
        SpreadSheetDocument,
        PresentationDocument,
        PDFDocument
    };
    Q_ENUMS(DocumentClass)

    enum Roles
    {
        FileNameRole = Qt::UserRole + 1,
        FilePathRole,
        FileTypeRole,
        FileSizeRole,
        FileReadRole,
        FileMimeTypeRole,
        FileDocumentClass,
        FileTypeAndNameRole
    };

    DocumentListModel(QObject *parent = 0);
    ~DocumentListModel();

    DocumentListModel(const DocumentListModel &) = delete;
    DocumentListModel &operator=(const DocumentListModel &) = delete;

    virtual QVariant data(const QModelIndex &index, int role) const;
    virtual int rowCount(const QModelIndex &parent = QModelIndex{}) const;
    virtual QHash<int, QByteArray> roleNames() const;

    void setAllItemsDirty(bool status);
    void addItem(QString name, QString path, QString type, int size, QDateTime lastRead, QString mimeType);
    void removeItemsDirty();
    void removeAt(int index);
    void clear();

    Q_INVOKABLE int mimeTypeToDocumentClass(QString mimeType) const;
    Q_INVOKABLE static QVariantMap getFileInfo(const QString &filePath);

signals:
    void fileDeleted(const QString &filePath);
    void rowCountChanged();

private:
    class Private;
    const QScopedPointer<Private> d;
};

#endif // DOCUMENTLISTMODEL_H
