/*******************************************************************************
**
** Copyright (C) 2023 Open Mobile Platform LLC.
** Contact: https://community.omprussia.ru/open-source

**
** This file is part of the DocumentConverter project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/

#ifndef CONVERTER_H
#define CONVERTER_H

#include <QString>
#include <QObject>
#include <QFile>
#include <QIODevice>
#include <QTextStream>
#include <QRunnable>

#define LOK_USE_UNSTABLE_API
#include <LibreOfficeKit.hxx>
#include <LibreOfficeKitEnums.h>

class Converter : public QObject
{
    Q_OBJECT
public:
    enum class State {
        Initilize,
        Opening,
        Opened,
        Saving,
        Saved,
        Failed
    };
    Q_ENUM(State)

    Q_PROPERTY(State state READ state NOTIFY stateChanged)

public:
    explicit Converter(QObject *parent = nullptr);

    State state() const;
    void setState(State newState);

public slots:
    void convert(const QString &fileSourcePath, const QString &fileResultPath);

signals:
    void fileConverted();
    void stateChanged();

private:
    lok::Office *m_office;
    lok::Document *m_document;
    State m_state;
};

class ConverterWorker : public QObject, public QRunnable
{
    Q_OBJECT

public:
    ConverterWorker(lok::Office *office, const QByteArray &srcUrl, const QByteArray &dstUrl);

    void run() override final;

signals:
    void satateChanged(Converter::State);

private:
    lok::Office *m_office;
    QByteArray m_srcUrl;
    QByteArray m_dstUrl;
};

#endif // CONVERTER_H
