/*
 * Copyright (c) 2020 - 2022 Open Mobile Platform LLC
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Office.Files 1.0

Page {
    id: root

    signal sortSelected(int sortType)

    SilicaListView {
        anchors.fill: parent
        model: sortModel

        header: PageHeader {
            //% "Sort by"
            title: qsTrId("docviewer-he-sort_by")
        }

        delegate: BackgroundItem {
            Label {
                x: Theme.horizontalPageMargin
                anchors.verticalCenter: parent.verticalCenter
                text: name
                color: highlighted ? Theme.highlightColor : Theme.primaryColor
            }

            onClicked: root.sortSelected(sortType)
        }
        VerticalScrollDecorator {}
    }

    ListModel {
        id: sortModel

        ListElement {
            sortType: FilterModel.Name
            //: Sort by name
            //% "Name"
            name: qsTrId("docviewer-me-sort_name")
        }

        ListElement {
            sortType: FilterModel.Type
            //: Sort by type
            //% "Type"
            name: qsTrId("docviewer-me-sort_type")
        }

        ListElement {
            sortType: FilterModel.Date
            //: Sort by date
            //% "Date"
            name: qsTrId("docviewer-me-sort_date")
        }
    }
}
