/****************************************************************************
**
** Copyright (C) 2021 Open Mobile Platform LLC
**
****************************************************************************/
import QtQuick 2.0
import Sailfish.Silica 1.0
import Aurora.Office.License 1.0

Dialog {
    onAccepted: licenseStatus.accept()
    onRejected: Qt.quit()

    SilicaFlickable {
        id: license

        anchors.fill: parent
        contentHeight: column.height

        Column {
            id: column

            width: parent.width

            DialogHeader { }

            TextArea {
                color: Theme.highlightColor
                readOnly: true
                wrapMode: Text.WordWrap
                text: licenseStatus.textLicense(Qt.locale().name)
            }
        }

        VerticalScrollDecorator {flickable: license}
    }

    LicenseStatus {
        id: licenseStatus
    }
}
