/**
 * SPDX-FileCopyrightText: Copyright 2020 - 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: GPLv2
 */

/*
 * Copyright (C) 2013-2014 Jolla Ltd.
 * Contact: Robin Burchell <robin.burchell@jolla.com>
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU General Public License
 * as published by the Free Software Foundation; version 2 only.
 *
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with this program; if not, write to the Free Software
 * Foundation, Inc., 51 Franklin Street, Fifth Floor, Boston, MA  02110-1301, USA.
 */

import QtQuick 2.4
import Sailfish.Silica 1.0
import ru.omp.documentprovider.libreoffice 1.0

CoverBackground {
    id: root

    property bool actionsEnable: false

    property bool documentViewOpenedOnce: false

    readonly property bool isPortrait: root.orientation === Cover.Vertical

    readonly property bool privateMode: false //! TODO

    readonly property alias __cover: root

    Connections {
        target: applicationWindow

        onVisibleChanged: {
            coverPrivate.updateDocumentViewOpenedOnce()
        }

        onDocViewChanged: {
            if (!applicationWindow.docView) {
                root.documentViewOpenedOnce = false
            }
        }
    }

    Connections {
        target: {
            if (applicationWindow.docView) {
                return applicationWindow.docView.documentProvider
            }

            return null
        }

        onStatusChanged: {
            coverPrivate.updateDocumentViewOpenedOnce()
        }
    }

    Loader {
        id: coverContentLoader

        anchors {
            fill: parent
            leftMargin: Theme.paddingCover
            rightMargin: Theme.paddingCover
        }

        objectName: "coverContentLoader"

        sourceComponent: {
            if (applicationWindow.docView
                    && !root.privateMode
                    && root.documentViewOpenedOnce) {
                return documentItemComponent
            }

            if (fileListModel.rowCount > 0) {
                return documentsViewComponent
            }

            return noDocumentsItemComponent
        }

        Component {
            id: noDocumentsItemComponent

            CoverNoDocumentsItem {}
        }

        Component {
            id: documentsViewComponent

            CoverDocumentsView {}
        }

        Component {
            id: documentItemComponent

            CoverDocumentItem {}
        }
    }

    CoverActionList {
        enabled: root.actionsEnable

        CoverAction {
            iconSource: "image://theme/icon-cover-search"
            onTriggered: {
                applicationWindow.searchRequest()
            }
        }
    }

    QtObject {
        id: coverPrivate

        function updateDocumentViewOpenedOnce() {
            if (!applicationWindow.visible
                    || root.documentViewOpenedOnce
                    || !applicationWindow.docView) {
                return
            }

            root.documentViewOpenedOnce = applicationWindow.docView.documentProvider.status === LoDocument.Ready
        }
    }
}
