/**
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

Item {
    id: root

    Icon {
        id: icon

        source: "image://theme/icon-splus-cover-docs"
    }

    Label {
        id: welcomeTitle

        anchors {
            left: parent.left
            right: parent.right
            top: icon.bottom
            topMargin: Theme.paddingMedium
        }

        //% "Welcome to Documents!"
        text: qsTrId("docviewer-la-welcome_do_documents")
        wrapMode: Label.WordWrap
        maximumLineCount: 2
        font.weight: Font.Medium
        truncationMode: TruncationMode.Fade
        color: Theme.primaryColor
        font.pixelSize: Theme.fontSizeExtraSmall
    }

    Label {
        id: noDocumentsSubTitle

        anchors {
            left: parent.left
            right: parent.right
            top: welcomeTitle.bottom
            topMargin: __cover.isPortrait
                       ? Theme.paddingMedium
                       : Theme.paddingSmall
        }


        //% "There is no documents on device yet"
        text: qsTrId("docviewer-la-device_no_documents")
        wrapMode: Label.WordWrap
        maximumLineCount: 2
        truncationMode: TruncationMode.Fade
        color: Theme.secondaryColor
        font.pixelSize: Theme.fontSizeTiny
    }
}
