/**
 * SPDX-FileCopyrightText: Copyright 2023 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: Proprietary
 */

import QtQuick 2.0
import Sailfish.Silica 1.0

Item {
    id: root

    readonly property bool isGridMode: fileListModel.rowCount > documentsView.singleCoumnLimit

    readonly property bool isVertical: __cover.isPortrait

    readonly property alias __documentsView: root

    SilicaGridView {
        id: documentsView

        readonly property int singleCoumnLimit: 3
        readonly property int prefferedColumnCount: root.isVertical ? 2 : 3

        anchors {
            fill: parent
        }

        layer.enabled: true
        layer.effect: OpacityRampEffect {
            direction: OpacityRamp.TopToBottom
            sourceItem: documentsView
            slope: 4.0
            offset: __cover.isPortrait ? 0.5 : 0.42
        }

        model: fileListModel

        cellWidth: root.isGridMode
                   ? documentsView.width / documentsView.prefferedColumnCount
                   : documentsView.width

        cellHeight: (root.isGridMode ? Theme.dp(120)
                                     : Theme.dp(76)) + Theme.paddingSmall

        delegate: CoverDocumentDelegate {}
    }

    Component.onCompleted: {
        __cover.actionsEnable = true
    }

    Component.onDestruction: {
        __cover.actionsEnable = false
    }
}
