// SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import 'package:pigeon/pigeon.dart';

@ConfigurePigeon(PigeonOptions(
  dartOut: 'lib/message.g.dart',
  dartOptions: DartOptions(),
  cppOptions: CppOptions(namespace: 'pigeon_demo'),
  cppHeaderOut: 'aurora/flutter/message.g.h',
  cppSourceOut: 'aurora/flutter/message.g.cpp',
  dartPackageName: 'pigeon_demo_package',
))

class Message {
  String? content;
}

@HostApi()
abstract class MessageApi {
  Message sendMessage(Message message);
}