// SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
// SPDX-License-Identifier: BSD-3-Clause

import 'package:flutter/material.dart';
import 'package:internal_aurora/list_item_data.dart';
import 'package:internal_aurora/list_item_info.dart';
import 'package:internal_aurora/list_separated.dart';
import 'package:internal_aurora/theme/colors.dart';
import 'package:internal_aurora/theme/theme.dart';

import 'message.g.dart';

void main() {
  runApp(const MyApp());
}

class MyApp extends StatefulWidget {
  const MyApp({super.key});

  @override
  State<MyApp> createState() => _MyAppState();
}

class _MyAppState extends State<MyApp> {
  
Future<String?> getNativeMessage() async {
    final Message message = Message(
      content: 'text from Dart',
    );
    final MessageApi api = MessageApi();

    // Add try-catch to handle errors
    final Message result = await api.sendMessage(message);
    return result.content;
}


  @override
  Widget build(BuildContext context) {
    return MaterialApp(
      theme: internalTheme,
      home: Scaffold(
        appBar: AppBar(
          title: const Text(
            'Pigeon',
            key: ValueKey<String>('appBarTitle'),
          ),
        ),
        body: ListSeparated(
          children: <Widget>[
            const ListItemInfo('''
            An example of a platform-dependent plugin generated with Pigeon package 
            that works with the Aurora OS.
            '''),
            ListItemData<String?>(
              'Get A Message From Platform',
              InternalColors.purple,
              description:
                  'Getting the Message from platform code using Pigeon generated plugin',
              future: getNativeMessage(),
            ),
          ],
        ),
      ),
    );
  }
}
