/**
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */

#include <flutter/flutter_aurora.h>
#include "generated_plugin_registrant.h"

#include "flutter/message.g.h"

using namespace pigeon_demo;

class AuroraMessageApi final: public MessageApi {
public:
    ErrorOr<Message> SendMessage(const Message& message) override {
        std::string content = "Hello from Aurora OS!";
        Message response(&content);
        return ErrorOr<Message>(response);
    }
};

int main(int argc, char *argv[]) {
    aurora::Initialize(argc, argv);
    aurora::RegisterPlugins();

    // Init MessageApi
    auto api = new AuroraMessageApi();
    MessageApi::SetUp(aurora::GetPluginRegistrar()->messenger(), api);

    aurora::Launch();
    return 0;
}
