# Animation Samples
Sample apps that showcase Flutter's animation features

## Goals

- Demonstrate the building blocks for animations and how they work together.
- Provide samples for common patterns and use-cases.

## Samples

### Basics

Building blocks and patterns

1. **AnimatedContainerDemo**: Demonstrates how to use `AnimatedContainer`.
2. **PageRouteBuilderDemo**: Demonstrates how to use `Tween` and `Animation` to
   build a custom page route transition.
3. **AnimationControllerDemo**: Demonstrates how to use an
   `AnimationController`.
4. **TweenDemo**: Demonstrates how to use a `Tween` with an
   `AnimationController`.
5. **AnimatedBuilderDemo**: Demonstrates how to use an `AnimatedBuilder` with an
   `AnimationController`.
6. **CustomTweenDemo**: Demonstrates how to extend `Tween`.
7. **TweenSequenceDemo**: Demonstrates how to use `TweenSequence` to build a
   button that changes between different colors.
8. **FadeTransitionDemo**: Demonstrates how to use `FadeTransition`.

### Misc

Other uses-cases and examples

- **RepeatingAnimationDemo**: Demonstrates how to repeat an animation.
- **ExpandCardDemo**: Demonstrates how to use `AnimatedCrossFade` to fade
  between two widgets and change the size.
- **CarouselDemo**: Demonstrates how to use `PageView` with a custom animation.
- **FocusImageDemo**: Demonstrates how to measure the size of a widget and
  expand it using a `PageRouteBuilder`.
- **PhysicsCardDragDemo**: Demonstrates how to run an AnimationController with a
  spring simulation.
- **CardSwipeDemo**: A swipeable card that demonstrates how to use gesture
  detection to drive an animation.
- **AnimatedList**: Demonstrates how to use `AnimatedList`.
- **AnimatedPositionedDemo**: Demonstrates how to use `AnimatedPositioned`.
- **AnimatedSwitcherDemo**: Demonstrates how to use `AnimatedSwitcher`.
- **HeroAnimationDemo**: Demonstrates how to use `Hero` animation.
- **CurvedAnimationDemo**: Demonstrates how to use different curves in
  `CurvedAnimation`.

## Other Resources

- [Introduction to animations](https://flutter.dev/docs/development/ui/animations)
- [Animation widgets](https://flutter.dev/docs/development/ui/widgets/animation)
- [Flutter cookbook - Animations](https://flutter.dev/docs/cookbook/animation)
- [Animations tutorial](https://flutter.dev/docs/development/ui/animations/tutorial)
- [Implicit animation codelab](https://flutter.dev/docs/codelabs/implicit-animations)
