/*
 * SPDX-FileCopyrightText: Copyright 2024 Open Mobile Platform LLC <community@omp.ru>
 * SPDX-License-Identifier: BSD-3-Clause
 */
#ifndef FLUTTER_PLUGIN_CLIENT_WRAPPER_PLUGIN_IMAGE_H
#define FLUTTER_PLUGIN_CLIENT_WRAPPER_PLUGIN_IMAGE_H

namespace Base64 {

constexpr auto image_150x150 =
    "iVBORw0KGgoAAAANSUhEUgAAAJYAAACWCAYAAAA8AXHiAAABhGlDQ1BJQ0MgcHJvZmlsZQAAKJ"
    "F9kT1Iw0AcxV9TpSIVh1aQ4pChCoIFURFHrUIRKoRaoVUHk+snNGlIUlwcBdeCgx+"
    "LVQcXZ10dXAVB8APE2cFJ0UVK/F9SaBHjwXE/"
    "3t173L0DhEaFqWbXOKBqlpFKxMVMdlUMvEJABCEMYFRmpj4nSUl4jq97+Ph6F+NZ3uf+"
    "HH25vMkAn0g8y3TDIt4gnt60dM77xGFWknPE58RjBl2Q+"
    "JHristvnIsOCzwzbKRT88RhYrHYwUoHs5KhEk8RR3OqRvlCxuUc5y3OaqXGWvfkLwzmtZVlrtM"
    "cQgKLWIIEEQpqKKMCCzFaNVJMpGg/7uGPOH6JXAq5ymDkWEAVKmTHD/4Hv7s1C5MTblIwDnS/"
    "2PbHMBDYBZp12/4+tu3mCeB/Bq60tr/"
    "aAGY+Sa+"
    "3tegR0L8NXFy3NWUPuNwBBp902ZAdyU9TKBSA9zP6piwQugV619zeWvs4fQDS1FXyBjg4BEaKl"
    "L3u8e6ezt7+"
    "PdPq7weElnKuCyl1gAAAAAZiS0dEALsAmwCMixwaYAAAAAlwSFlzAAAN1wAADdcBQiibeAAAAA"
    "d0SU1FB+"
    "gCGhMVNpXIuXAAACAASURBVHja7X15vCRVleZ37o3MfEtBbeyCG4zLQOOCyLQsXSzS4jLqzAC2"
    "6PxsFQURR3GcUduZfmqLbdsOrrhMa6ujLVK4tU7BsFWx2bYD4/"
    "5rQRG0WKuo7VXVe5kZce+"
    "ZP2I798aNyKw9X5FXg1wrI17EF9855zvnnguMx3iMx3iMx3iMx3iMx3iMx3iMx3iMx3js1kHjU"
    "zAa4013/"
    "vXiVl+dGimcqKCPJUWHK1AbhM3E9LOE7VVXnHTZnWNgjcfAcfFtH16qCecrpf+"
    "DUuo0rXVLk4LKNg0CEQEMxNZw3/Y/e8CJs5fO0Iwd9b8tGl/"
    "evT8uue3yk0B0qVb630dRNJGDSWdbhPRRQUFRCi5DluaAt2z50aLNAP5izFjjkQ5muvi2y1+"
    "sSL1HR/rkSEXQKgMTykdFlAIKlD2n7DIxujbG5nh7nCT9Yz5xyrv/MGasx/l485oPvTC6/fK/"
    "0lHr+ZHOAJWBSOcgAqV3Oaf/"
    "YTAsE0CUfwIFgibV6gOvAXD5GFiP03HR6g8dpyL+qFbRiyIdIVLCxIFATIXJYOYMUAQmgLL/"
    "MaemkLLvKACW7RljYD0Ox+tWzyzpkP5AFKmLo6gVRaRTQFHJTCk7MUp+"
    "Kv0SKpgKYBByg2jZgpnBzP967GM93ljqlg+cR6Q/"
    "3o5ah0c6QiQYqnLCufhP9pn4TmYCFZBGhiBYtpgzPcz25syGdcnUyvNm+mPG2s/HG2/"
    "80KE6Mp+NdPuV7ShCwVKlscv/77x2cZa+QUQgTs0iiEAZAA3blLVg9QFHzHUAjIG1P48LV3/"
    "wpZHmL7ajiUNaKgWVotJ/"
    "cpipwBM3RJAoTKPNjCEyU2jYgq3FRDzFYx9rPx1vuvNNLWx9wodbUXRZO2pRW2loaBBJ3HDuSh"
    "VvMjcBi5BRVPFdyv6tsQbWWlhrzPqNuj8G1n44/"
    "nzVew6mbZPfbLfap3d0Cy0VFY55DhyuMBVXzJ4PKnKAmOKMOXXvDVsYNrCWt6w8byYeA2s/"
    "G6+/+X1Pb6vO/+602kd3dBst0sKTcgHFLNmHqzbPcekZTDKuKv0wm4HKpIz1cLMtHQNr4Zm/"
    "m2aeq7W+biKaOLijW4hI5RAomCW3YSzsmfSrOORUiae50MACrMbaHFSwlu8d9fM0BtaO6FM3/"
    "rcTtdbXT0YTSyZ0G5pUZvIYdlhA1flXREEzmYO1ZCwDY+Jfj4G1n4w3/J/"
    "3HteKWtdNtUpQ5YBicDOguImthJceDBC5iAaNtTDGwDJ+OgbWfjBec917D4/"
    "anVXTrcllk7oNBQGqIhUDoaRL3YoDBk/"
    "q7HVwSn8uBRZnJtDAGgObdO8aA2uBj3OvnmlPtviaqdbEUZOqDQ2VcRSXPtVQgGIPT3UMVUaQK"
    "bhsKjHkjJUkjz3z5wf/"
    "dgysBT4OXGY+PNmafMGU6iAiBQukDALrmTgWygIHNKx6PHGIrXLgcmoKbe64G3PHzMy40G9hO+"
    "s3vG9FO2q9fVpPoKU0OAv7U1CFwBPys1zIUCF3hqElo8scVJz7WCaBMcnqhXDuRhJY5159rj70"
    "iOe9JFJ0BogOZzBb5vVg/CaJzU8m2hN3XvGCy+b35DFcuurSzjypz0/"
    "rCdVWUaElSVA54KoFlOu0c4P85Ghg7DOWgUkSILHXj4G1MyyxemZiSWvq2slWZwWIUue18GmAl"
    "rYwbObfdsdHbjfE34sT8+0vnPYXD+/u49imF126KGo/"
    "bUK3QVllQZoAZoTSNFUZgdHsTbkRoaPJF4xlCzNojEESJ/d981VX/"
    "ssYWDsxJqAvWaQ6K9poZSkMi9ShSAvgQApQmLSKX2hgX9gi8/FLf/"
    "jXN8RJ8sXDTPK9mdNnkl09hgtWXXqg1tG7J3XqV+"
    "WRmSsr1EkJ7GItNMj11NlhLA77V8aATfKPC8WNGD1TaM2LwYzEJDCp4XFOPmWTCyIQWhQBOooM"
    "8zl9lZyzwSRrL7nt8o9z0v/ClafPbNvZQ2jrRW+a0O3lbRUBDFhU/So/"
    "8vPLYKomj+"
    "AjjivyQhhUxhokSQKbxN9ZKMBSo3ZAiTFH9E2Mvo2zbH6a0edss9bAGFN8BstoQWGaOlgcTR41"
    "3Zr4WNSe/N0lt1/"
    "+9plfzbR3xr8joks6mQhqwa5fVQCIXdPlmEbG4NgPrvPPpXKPwmnnwgyauP8gos23j4G1k8OYp"
    "Nc3KahMWYoLzqIjtjbTdlJwJSZBYhJYNlAgTKk2FremDp6OJq7YuHniZ29Z8/7Td2T/"
    "Uwc8ZUVLt55cOOwFqDIxVJovZqc8ppQKhhnSVxOMxZnZlU67SWATc/"
    "XK81aaMbB2lrGSZG3fxEjYlGByAMYZuNLHVDgsAWaMgWbCtOpgcTT9jMnO9E2X3Hr5FUOzF6lX"
    "tXUEDZXqVVyq4BI8FVF0h8DEgtiE7yb8Nxa+lenHiJP+VxaSVDN6jGXNT/"
    "qmn5o6toXTXIiG+RXxmSwHmE0QZ4zXgsJiPUkHtqfevmFT5+"
    "aL7pg5pGnfMzMzShG9tEUR0gnItvB5HMdImkVZb5WZsfoNnuYl3i9Al4uhJVslcfx/v/PaL/"
    "1sDKxdYqz41jjuIzExjBUXVtzlzKXZkHpPHp4bzgBmY7BlTKk2lrSmT25x57Y3rp45sm7fvztp"
    "23GR1odFSheRIDxQyRiuwJUslxmSuVjIDA4bcwmuDFQw/"
    "fhzC01cHjlgbZ3EbXHcn42TGMYmpdmTbCW2slpTgCy72xNrEGdBQAcRlramnzbV7lz/"
    "hutmloXPhjpFKw0F8vZZBZU0jcODiQUghbNeMLAVjGVgkwRJr7deTc5+"
    "YwysXRzXvvhTPZOY78ZJnKYw2HjsFLhg+Wdgxx/L2Su2CRKboI0Ii/"
    "XUMyemo3+Y4RkV+KWTIqWKMjt2QCDpMuRX+aAPRIkOu/maVek3srWwOVv1+leuPG/l/"
    "BhYu0PKipOvpOYwKXwtZisc25qpUzJqy8P27O4vwEURFkUTf/"
    "rw7XRplbDUHylSNbICAknmQfKCa74RYjxmQIAq1a0SmCRB3O1tNdvtp7AAx0gC69h7DlsT9/"
    "t356xlrSnuajg+jth8XShnr6xQzrJFwgmstZiiDiZU64Nv+"
    "fHMYdJxJ8IxBV9J38opjfH3nz4lsbnE5Zvu0m/z/apcRrFJgqTfh+32P/"
    "mdt351wxhYu2nMzMxYTswnkrifmsOCtaTZ8wlCAkyG9KXgaKxBwgmIgSnVOcD08d78n//"
    "s+PVLiXBA3iNBgofZjwC50bUij8lczUsGI9bR53JQmThGPDe/"
    "Pt665W+"
    "xQIca2SNrTX857vUfSZ14k7GWrRTXYQDACqc7A2UqvBq0EaGN6PWvWz2zBADQ5kOIqHSzBXhkb"
    "R7V7VcymWM+ufg35XGXPhVy0TcDlU1iJN0ekrn5//"
    "7dd3x38xhYu3msPO+"
    "KeRMnH0n6fZgkdoAlI6n8IlIIYFLzEvVNiTUgZkyo1nS7Zc8HAEvJgY65qjNfjc46B45B+n+"
    "OXlJmEjIh1CYxTK+HeNv2f1arzf/EAh5qlA9ukUk+F/"
    "d69ydxnE4ikKzFoagt5D+"
    "7YX0KrjRd1GINAlJg9eIJJzoTmwQODZIYGA6IZMQKL3uAPAdqEnASw/"
    "b7iLfNdZPt3TesXLlw0jcLDlhf/"
    "vMvd+O53rvjXhcm6VfA5YuXkkEowBwl63CRW2xBn3zBqksPtCa2nEsbsEAeKHjKue+"
    "oUwBMjoDqyBQpmGBtZgJNCapeD2b7HJLZ7e/"
    "+1mXf+hUW+FCjfoDfvvCrVyfd7vVxr1eYRGtNGaI7Jia78KiCjDwzlEsYEav2xKLJE+N+"
    "b87YNJmdi7JgDpg8b+OUxSgkM+T7s0JSYAtYAzYGMKYAlZ2bQ7Jp9ppvXvatT2I/"
    "GGoBHCPTfPfN8dzcbNJ3wcWcM0tZgUBOqiWkKbm+jWIAVh2fzG9/"
    "LIn7KYsUwLVVxmqygU4kah1fKmUqk4IqZ6q4D+72wNvnwBu23EUPbXsdRnzq/P4ELFx18VX3J/"
    "PdS5K5OZh+DzZJCgAUZhFeNJg59MQh0TLPK6b1XDD8pC3m0YeS3nw/"
    "BWwGLisZMaCdVUDnO+m22LgwfQacJOB+H7bbhd22Dbxh8z20YfYl/+tvr9+O/WSohXKgV1/"
    "0ja/Zbds/"
    "bebmYPtd2CRO73prhN9SXliqpFLgfM6clftaA3Cy+"
    "K433xXbXu9frIkz0Fowlya3YKC6VE4BKFswFAuWgkmAJAHHMbjXhZ2fg53dCqzb9Gu1afaMv7v"
    "8pkexH40FNf3rgUcfeceTk0OONJZfoaYZ1O6kne80A0pnF7noPwy/"
    "11TuwLOT9E2gjI0BgOd7tyVTvWdxS4NVCs20SyOhfuaynLEjgetqVGwynSrug7td8NbtwIbZO+"
    "xs9xVf+"
    "Niax7CfDbWQDnbNzJrkAN76Kmzc9B0zOws7Pw8b91P2SpLUIXb8IwvKBEoqhEqpIaXOs+"
    "n1HgQAnu3+"
    "YzI3BxunbIjMLEqTVvpPgde2BBJMkh5TEqdmr9eFndsOu2UW9tGNwIMbPh89Rmfuj6BacIwFAJ"
    "9627W9c68+99ylv9v4UbO493YccABhcgJotaF0BKs0lFIgpQBS4LS3dTmVoWCS1IE2cReY7/"
    "4TAERHTN8cb9r6Oxt1nppOTmUoHQGK09lBeT/QvDOMp+pDlk+b3J9K9Sk734XdNgfeOLuONm2/"
    "5MpP/fAa7MdjwXZNvvqEExbfc+yi/"
    "7LuqdPvSQ5fSnrRFFSnAxW1oKIIpDRIKRCpoutwAQJrYE0C0++h/8gGc+in/t/"
    "7VWw2klLbHjn5oLP7pz3l1RNT09DtDkhHUFoXQKUcpYVlzX/"
    "TlgFF5qDbfhr12W1z4E1bsfSXm3Dkb/"
    "tb2gmMIkoipeYVqW5ENK9IPRwR3UdEa7VSaxX02n6sfv7Kn67ZPAbWngTSsce20T7wjwn2TAt7"
    "lrH8vMTa1jwZrH1KBxuOWwI6dDHUoimoiQ5UqwWlI5DWgFJ5E8YUAEkC2+"
    "simd0KfOOXaN23NevBDigibH75kxD90RMQTU5CtdsOUGUfq4KprAGbXEFPAWW7Pdht8+"
    "BN29D5zSYs//"
    "V2TM0DLVJoKUKLNFpKoaUVWirtsKyVglYEVdwM6BPRHZrU9ZZpdXuC7zp9zZpkDKxdFbAA+"
    "t6Jp5xJ4ItBOFsRLSIiMDGsAiwBsWLMJTE2JX08sowwf9QUokMXgRdNIJlsgdstQGuQIrDl1O+"
    "Z64If2oLktgfRf2guXfGBCDpz/"
    "dFRMC99MiaOORhqsgPVboOiFKRE5do2RVomScBxxlDzPdjtXSTrt4J/"
    "sxmT981hugtMKo0prTGlI0zqCJOtCJPtFtrtFiKtobWGJgJlCw2kjSJKBd8ygy3PgvADEH96xS"
    "03/"
    "dMYWDvBTsuXHnq+"
    "0voypejZKlJQLQXqpBvaCtQiQGUbhN8jLJVVQExATzF6ZDHPBtvjPnrr5xA/Oo+5+T42z/"
    "WwsdvDbD9GYmx5UjRBH78UU8cdhNaBk6BOCxRFgMrWtmELTjJQ9WLY+T7MlnnYR+eh1/"
    "exaCtw0EQHy6cmsGSyg0WTHUxOtNFpR4iizA8EpTpaqqUBidji7D0LsOVisgZbhrUMBlZzknz4"
    "5Fuuv5FGUFQdKWDdcMJZi6MDcKGGeptS6igigFTmfGsCIkoBpSl9nYEpjfZcE+X8eeT/"
    "xVR5jxUQg9Flg25i0M/"
    "6USURgCUtcKRgNLJl3wgaBM2AtkCbCROs0MlW8RJd01Jn33rZAOez7LXJvpcBi00OLBYzgNyOz"
    "BYMtvixZfuRhw464HvnjVDiemSAdctpf/ofofh/KKLlubFJJaQMWBk7pY/"
    "Za2kzPb2yCrIAoPIzkDpXgBZb/p7K2JDg+FduL3cPNBCVpP4xyXxm/"
    "n5eGGtdhkpBxVk+XMzsYW+"
    "WTxpE3GWIXn3qTavuGQMLwI9OOufAXsdcSYQLJJjK9WQEuChbAoT8P4AqIKquWTPgDJAAkAOmD"
    "GBUZTu/c3ZKfXCaflDoNDMFNFZyy5kLyU3KGaEpb6XkYYEtlui1p9587fcf18C66dQznh8p/"
    "XViHFMACGXjD0IGIlKFAk7CnwqRT6BmufKUxLWtnACiKuAaTKgDHQrYXXIfqXgtfUOqHm0OsDx"
    "fmVdcWJsGIdYv1c5ARrCW7QdOWfOCDxL2Xee/"
    "fQas1ae+"
    "8CIFfAKEtsNU2Ybiucr8rPL98gJJsHh9FASe6suJhz0zIZaiIMAKpsvXc5YpIRKb8l5LoMlyIG"
    "awyaJPY4pHFgADy6lkWUNc4LvLH1t8/rG/"
    "WrlPlkbZJ8r7zaec9XoCXwmAiCFCeHniVWCj8oIJABVr/"
    "zlVBnBKg4l34c6r2l6XvQrgoDh+Es/"
    "Tnl4+sFT56AAyD2nzWi6bRgiJSb9jTPl3kimA6LAcAwR+"
    "xcblmz8J4KLHBWPdeOqZr9DASmJE5PhQlCnl2aPWgE4fSZfiZMFa2UmsgKqhnIUG+"
    "VtwTSWhAVC+KVPl+5SDKWcmJZ4XIPPABi/"
    "gkOXLxgCJASdpGip9nqSibFbdwZadku3MLMIyv2XFbTd+dr8G1k2nnXGasnQdgEnf9FF29+"
    "agIq1BkU7FzUiDlE6jQnkhODeBeRTlFebZ6txD8hZOajJ9FGQmeCZMspQASwhEkqXkv/"
    "elkrw4UJhATgSgEh9c1jWJTiMVxAR64Wm33XDLfgmsm085/"
    "VkMdYtiXuxEfdKP0ipNnUQ6VbqjCIiiDFipOXSBJRjLipopy2GQCRPZ+"
    "IdTSHQNg6li2iiTRBrB5P2Wx1a5k56CymYlzAJQcZyyV5KknxVVFV7EiLzCn9aTUif8ya3Xr92"
    "vfKzVK1ZM2IS+QcyLgxexCOkVoBWgdblF+"
    "XNVXpzAHQ7FqdTONqUlRa6fQq659PuFEnn3mmQTyvqfZiaPQgARYGIRcFQApaQvCXgNSUsSJQI"
    "TOY/"
    "5cbAAN1PzChfpD9qDjeGPAnjV3gLWXqnHsrH6SzCeWQWUPEFVZ51zMGmVFvIpBVYZyLKNxfMSl"
    "Nn3i3+v3QBA+SYq3T+TAkuWEZ+Xx6HA2Va8J/"
    "eX7Z+L73uBSCUiRAGWUM9ld+JZCUp3+oa7wBP7EzrSqPm8m089/"
    "eT9BljXn7zieQz+z9UeC4IhpF8iL5gEWQUQqnjk0Kbla/"
    "I+d1nAEUNRskL5GGYozgGpPLMnmKbcXAAx1fel4QC4GP6E2fI3Ki0q2evgnJpGsoauYMyoBQ+"
    "sq489t61AXyRGRHW+DPmgogIs+"
    "WvfJPjmoKINqbCJ8sEhgSMBgIDYWVx0QmkWhY9UAEZ8J9jpXSw+UJkYW/Pab0tZpnT8X+fqvA/"
    "RPJfAJ978glsvWPDAWrp4/XvAfHxw+Q/"
    "hGLPjGGfsJMEklGoWDpGcMsGhJLPQlziQSXFrq1CdexFqVitaGbHI1TlsHJzHIb7vTbf3wYQA6"
    "BzgBVjK67eD4MIGabR5+apzzuksWGDd+PwzlwN4Z/mX1y3+WGWRkGDo5pX9qe/"
    "iIrL3WGM+Ar0BhXLtA6Xs7lcygCcPIAyGCiik3iSnl+"
    "VyQa6mW86iPOuxF0QDOrfzDouugxXDWf7GkXrL/"
    "CsXLLA4Mm8F8wHBhWrlaqIiyGNh2ty70b2LXSCxKCnxlnlzptbDnaTsvO8vBMAVlvGF1wp4LFc"
    "nuNpyYymJWOv+jugCndbjy/bjXE7S8PpJyJvAXXta/"
    "q2SKTOeZ75wQepYq1esWBT3cD8xLy8JiFyFPfOlUlU9lRUo06yQaVgUaSAvCfbDfJkDLO5k6wm"
    "j1pUcajStSn5RJrmbtCuR0wzKCiK36TCwZ4Kd7oE5SwlAwZhMz0pKFd6kSnxeFg1Hy7JOa03fb"
    "Nv0Hn762f98628WlI7V7/"
    "KFBCxHs8JSKjiumF70XuBsyhazBbEqrzt7Dc0ko9gG5b3S54EdobXYd/"
    "775DkxXkozL7FJpSLrAotDQijV3sp+K+/SHOYpG+OwnxRDwXJ1DPYqbwSb5SAmkCW8EcB/"
    "XTCMteqcczp609y9xPyEak0VFbnAtGhP5AOL9E3GVDoCZZJDPkPGrcUixyklyVo+"
    "oKQq73eG4Wo1BAKBACENJKiBueo3yVIeuMT+nU5/"
    "VqjvDmuJhiKy6qGYKSQZC5Wqh4K1COt4w6Invvi31/"
    "YWBGPRxvlzAX5CcZMzV5KsXMCilPaYc3E8SxizBVsCUXZ3Kpte3GJeH5d5v4HN+"
    "xtAVbsEKom8IolOx+"
    "QwV9rLqLxpmELKvAQUVUMOb41C3xzC2DIhzbbKVI6f5a0m5jfpLZ39Q3DQ7Bn4La5dGKaQ7Ll+"
    "OTALfZiLiVhUVBtw1mshLW8pTy6RTctyFUBWSA9gUS0Sahk0oHGHBCXqGGuYJQEYJIDGGci4Dl"
    "h+vtljLCdPKMxh2QdC+F6hylIgYBpRYayiZt7QmcACANaqk046EMxnO+"
    "tqU84KohcCu3oQFYyV+VWWwWTT+"
    "V2wWRmLLPAj4f94pTG15TNcNTtoMINeYph884u0LoVJOF8FyLhavOc77dK3gnvMVXCVwCorSWt"
    "ABbetrvS9KhEw8ZkLwnlnbr2EgInSxJXc5DjlGVsx57grmcoBFzzzF6gGIHZjbK6AypGhfb3BL"
    "VduKAh0HPkMVKntphJIAWG2CVSOafKkjIo5dFir7BtRVwvv6F4VH6uQH47//gkrDnrZXbu/"
    "f8RuBRYR/"
    "TvZoIwpNRXs9E5Iy0Y5080roMpNYEF2lPVOoMKBrrrvgWVEfClCMmMlF8KNPnxFwXacRQGuOjA"
    "1VSDUAYtrpIcB4mnxCNcMyq44IkuhQP0VAK4ZWWB99fizp5nnzyEWrJSfc8c2pmCpMJQElfXUe"
    "S4d4/"
    "JCcaAUgCuKOQlQsJ+"
    "gDfns1dxNPcgIqY8FLitOhaPOaJYY6oDlslbeEbCcSFGwlS85gKuCskzy+"
    "IujM2AJZ440sJZMzJ0OxnQehRCVsR9y1srxRZyBC45WVU4rL01kXtwnQUW1WKhWiTLXoaM0pYz"
    "APBkOJZCrAOO86J6pfF4BFBUzvIK/"
    "zXKVVXZAA2eGjgCZZCtU2c6NFqX5c8FmgT8eaR9LAyc4C21nZqI0hZxdwNRnSsHFpcRgRWSYzz"
    "OhjNmkyu2lhFxfiz3/"
    "lAcKeMEO7TWzfWptpQQveU6+"
    "iAg5CF7XDwqaRC5n47jg4vroULAhVxx3YQ6ZjmYxi2DkgMXg50hFnDJbkPpZKB12IRXkzAWpsN"
    "vShJAXupMshpNpF25e6ZT8V3VnkRtYi2uA5nh7VPXFKGj9qkCtCT6kvyVbVlYddPlTfqTIQsZz"
    "GQuERVc95+"
    "TD8ZM7HhpJYFmL56jS9Sj9jgpj5Q40lZ2OC9ZCVmJsS0fdB5XjvFMoxe1cTTk5tWgdyS7QCHVm"
    "rxpBysgxtPB4LbKDLl11ulqtv8VVE9k0S9rRtBwtC84sHmZGG3wMgNED1ref//"
    "zlZPkotyBNOO8sJAYR2qcgtGBWKZiUSinfK6ehvBTXSbHIa+"
    "VxEkmjQzXXmgq64zqzxg0XX5r9YbSwEMdzoMqiKUosfDEbnH6PEFOhqtlVwAVzDIBbRw5YxPrZ"
    "hYbIAjjCRyJwtT8Hi7QPUIAq7WXlg6rM2QF+0R45UT2zdJ6L0LSaohskLdQAy/"
    "dX3LInDjJUnT3kgcCqa5zL4d4OTnrHM33sljLnB2AIx4yk865Az3bX9BOmrsi9pEgiKf/"
    "k7GWz0D2rDmNbEhZLfcjpeeDambDJK8FFjjEeSCY1wKoBma9os8dIDcCSijk8QdMFk6fMB3Kkt"
    "aAKmEOnzpT4KSMJLGvt4UrcwJSLoxm48pCDmJyUrviF9IJbqiR0i4QzpWBhrgKrAFXxmauMS2z"
    "XYYt8zTP3/"
    "fyFoEKsVQOwSiXqQGD5UaKfoIa3+BNqfSrUgordcun0vE2NJLAYWOxlzjMQ5REglWBjeAmfqn/"
    "rdDjO0zjsVQmw+A0SOZfiu3mCmGv8LDfVVG2p5bNG6GLXgatqbIN6WqX8GS47AgPABaFj+WAS/"
    "lTFHLLTzssAnZEEFgEHshAnM3otUjKprJDXNLHwwwKg4rJKAJlvVoqPOXjKeJBFH4ecGom8BHE"
    "g9SJy42Hnvda/8v2eBpMYYrC6AAGhao0qY3LwuSsr+I/"
    "smOUAYwHt0TSFzIuVVL7zHJ9Q2WWYX5a8kMtaLHyqzKlnAaY8a52bVPleipDUZLIDpACo5O9yj"
    "Uvf6Fd5FRIDTKKj0g+IQBvBBV+hLz+"
    "rVjiwqHmXaZ0qY1myo8lYEIwlkxgM1ywVSekizxZmLQdUMgAgcsHHpemjDHxlwAAnKiTBXkzCz"
    "A5xsYPgYq7m+"
    "kJmMGgWuUHl52qdlge4kOmrspYHKvantGU1WWmf3lFlLCxW8GrREXKk4QDBAVXOMkL/"
    "kiefsi+FTJ/"
    "LaOSChinAXnD7SoWyjzxM1QQXckl15k8zwLjhOxwCWxOD+"
    "ezl6VVwcoUhB55GlrHa1UmpwseSeUI/"
    "3cFVqbOQBbj0p1j2GZXdZnJFvgFUVPG3ZJgICCm9JoXT7LDzjrKWn4IKpJLYU/"
    "3rgFUHqIpuVXb6Q76ci0Whvs+PaFTIjzFwjONjST1JmEQUzrzQn+"
    "q0JAoBBsHn7P6jaiGeUzPF3rGh0TQ1RoGVOYyDQYWASFnxtQLvV5kKtQ47QmwlboKczdJGzfTw"
    "aAKLeR3XpP2LBHQWGTap0jJSC6bZBKBIAsrxq+"
    "o0rBDYahJ6OwEubhBKa5PcCFRiDAJWLchkvRkLvdVl1UrekABDeGRUdax17IXdBR855QfCrOWa"
    "VgNlFaKCMwkxNX8W3gwg32mvMJ4AFzjQ4difDY2a1E3gMw4Dob6YkMMmMSg/"
    "eCYvBKwAoPwoMJehZUM2i6L6ZkQZy/"
    "I6Cw7M12e3Wwf5NebCaJJX548BZcLkiai+diRrudgVTstkI9f67uHa+"
    "CqoWEx2HcxWXHN6Ag58gDnrkt8hQPkmEAFAWTAsAZZG1BQm4HURN2T5C2fazz7n5EEDJlvJvB/"
    "q8zIOyPLy6BBjwV15tW5qYV2Lb4+pdhuomoDlq/cDAIWQT5U57DYHV85YEtv3/"
    "AAADEZJREFUZEcTWACtY1hYzruMiHmDzkmXrOUxBg9DVQ0J3aBJrOpdTtqnEcgh36dkqKoe1Sy"
    "O1vtWDaaw4XXoOSNUPVqCy0r9KgOXISCx9OBo6ljEjxADKosyVOhOdFgL7jIh3ptBbElMNJBW1"
    "WR6aR0g7NgFd8rBdXlsE5AYzaJrk47lg6WWxdgj0rBvJfsAFsvzSMkBDANK5lu4eySBFdn+"
    "Tw1HljhtkWHF9QytcwNXmRo6QqgukEPh14LB2NdRfTMIatSaZFHiMPnAYDVDSBytYTLHf6pJB3"
    "HNZJEqoMLOujSFDP7Zu37+i+0jCawLfvGLTV857jm/"
    "sOBnKa7mx5wgrUgsl6aRuRYilXdriaqCMwmu0uRyOOtcr9A1TqYI+JTMQdIM+"
    "pBDMtlAkwhvFjS7zdfKle24ZKq0wA8x6IfYA2O31bwb4BYAz4KMDp2LHWAuTzoi53W4ol2e8mr"
    "DkcC6hRRolhCoPq1jjh0BUaglZsUXGwZYISDJSDTwuxW/"
    "KpAfdNmKs+UQ6Y6RBhYzbrXgt0FcO3KsTtXnko5wSG/wmaxWnIdY+YtC4AqZvWEYK5R28cN/"
    "NJvBpvcDZm4QIOvAVAuubPcSUDZjqyRlhNFmLEvx7Wx1UeKpvGsi16eRde5hUFH1YoTeQ2B+"
    "TD6fEVT1l4iFj9fEVwOYa1hGazCPg4DHjb6ZByYn6Vz6hFayFdL8oAFgclMIWvuue3/"
    "5wEgD68Jf/vLRzx97/"
    "N3EeIbMGZYtRsNz7gqtKWAO694bRkXlputLPBA3w7NXPbB4GMYaxIIB5uKQWXTSOFXfymaAspw"
    "BiwAD3LET4s7eBVb2R37fAs+"
    "AuH5KuN0kgJLXwENOcaCyGsI1iU5ae8gIskGP2ImpWj6BEOoqFIYDHeqYkps/"
    "q7Td9huAwC2NydM4JntukD5PGEhgv409NHYrsBJDfwey7wTShqEKxTQJ1yQyVTv6kQs0SKYLmQ"
    "PCoAnHnj62M5iqbxzCQ7FYmO14wPdqFYsB4OIAuAqFXbIVgJiweUN3+w/"
    "2FLD07vyxVY89uuFFBx96GgFPLSYZMjWSBfuNM7zPgheBwic+sFB8/"
    "UIAjQDggaDyf7e6z7pe8s3mO8SC7MKoOqUe1V7vft2VRe5fpU57Qvjah++/b2EwFtID/"
    "jwxzhQrfQpzWJ2BVc7aYUeMJ6GQ+9UtQ62WStVIbkDVztDE1fhBo8nzsgoDvlubAPDEUn+"
    "eYJ4TlEq7cdkKMdTXsAfHbgfWZrLfWwp6FIxD0+iQHemovLhyyj27C8B7YKu/"
    "djsOk10BFe8isOqEBeYhv89V9vKZiiWgGA5bJWDEAGKm3+t7f33bngSW3t0/"
    "uGb9enP2QQcvJ+"
    "ZTSkZqlgjcu5HChqliFmkH2KrGXA6zMWrMKNcqC1xzDHUmtC7wbAaRv7xJNeFcslVpBmMCYsJn"
    "Prhp400LirEAIE70Z6CTt5HFFMBQIpLyzaFrnkQBjT/"
    "h2fErapLIaEDsjjIZo75OazjBeGj5Yjj5i8PrGTJX/"
    "DiZcC79KkYCoM+YnzOtz2APD70nfvTGjY/OnrHsoAkC/"
    "qR0y6vz20MTRuvX8JNt2dzoMLy+345ttReW65xwqjrvO8B+jphZc9zO+"
    "35y2T8e8dsyyVxlK77yY/"
    "ffc82eBtYeW7p3vq3+hmL7Blg+Ir+"
    "zlNCzCuYKNGepvpa1W6Hk7HAktTPOe22nv0COj4bYBzWKsvXCLQcE01DEmbOVEaJokkWCfWB+"
    "exz9DfbC0Hvqh9esX99fsXT5ZgK9nOpqrLjKMkC5DqFM7e2ODahf0XR4xuGBv81DArWJ1RDwww"
    "YxlatblWyVAOgT0Fe48hO//83KBQ0sAFi+ccPPD162/"
    "N8S4zCIiG+Ykw0MZ7p2FmQWuwm0zLsE9Ka/A74Gx/"
    "XamEzflCp7GQn2CPO9pHX+j2c3bN0bwNqjq9ivBMxxjMsIuInBxJwiOVs0y6l+"
    "IM8H5wGx35DZt6E+32l9CwPUzt30ayGBtHqjlNFgnmTOhFD0AfSZP/3ptXc/"
    "hL009J7ewZpNG+4/"
    "ddnyZxJwHFVMINfKDyzmRDP8ZXq55jU7jn6QDXiwGdv1bXc69w1mULCvU8cuosAYQF/"
    "R2m0T7fN/"
    "smFDf28BK9pL8H1rbHAKg58gWSvPFVOAscKK1rCveQhZsip+"
    "7jxr7Q7K4sbj8Gef2exdK8DlJJkzUPUAxLCXfunuu7diLw7aWzt639FPPyNie0OLWWkAmj2T6B"
    "0QDd+AeCcuXcPnux9huwhLtwdiiOUceUGwVY+AHtE1V/7+vnP39vHrvbWjWzdtuO/"
    "fLF02oYBTa9XqgGncGdMRctSbTEn9dwL7ox3bd+"
    "NG1d8JBRW2coyuGQwlmfspsDZ32bzsJ7OzW/c2sKK9ubONSxf/"
    "5bKNW87oACcxGDq7QMpT5f0JyiHTMhSp8MCpEjvOJANmjdHO0dJQznthBjPxr8wFpluSR4EEdA"
    "H0QO/"
    "+0tq1D+0LxqW9vcN3HXPM0crwnR3GkqjwtzLxlP2q0+"
    "rZpSHNWu2nPDjvx3voRPMQJ30QsHwmy81gIv0qAuaJbnjSH+5/0UxJgvs3sADgnU/"
    "5V6dFbK9rMyajLJcoWctvOzn8nc9DXyTHUy4Ax3vxxFP93qiBrZwJEig0q5i4MIFdontjm5z01"
    "Qcf3LCvfETaVzt+x5OPeXmL+ZoWOIqydI8SDn1F2+LhLzoPkSIZju+"
    "ofurWoJNKu35q66QQ31k3GVPFBMyDtvZgTv76Aw/"
    "8Yl8GH3pf7fhHmzfefeLSZWsZeDl5rTzk2azVcgKKt6113P0k7Y44+"
    "c3VoFX9bHBKaUcCjaqcIJ5TmQvMmMr2QK/"
    "++gNrb8E+"
    "Hnpf7vxHmzf99LnLlmxn4GzHc3JAxTWpjLp8WR3AOBCm16d6dgxkOwciWWfGtT6UH/"
    "2VLJUzVZ+AbspW7//GA3/4HEZg6H19AD/"
    "evPmHz166bBKMU6RTXlvUxk13OTtSgK0FG4cByDvDXLsGIAimG4atsmlbSMBpqgbAPBF6wFXPe"
    "HDtf1qzzxW4EQEWANy5edNNz16yNGLgNL/"
    "BBdeArE7LsiGNincQYHXM5+"
    "tY5L03JFOhwWxaAULJWD5L5RULXQBdhW8tPuzQ13zs4YcNRmToUTmQO7dsvvn4JYvXMujFYGh/"
    "LeNwaUnYxIUAVmGDAYC0O2j2wtUSFAYVDednOX4ViRk2hQBKmCdaufSwQ1/"
    "9hbvuijFCgzBi48InPvUsxeaaDvPiKOu5lUeL4MAksYGNNcJiKDdJEEMrZXVCQv3ZHa5agxzwu"
    "emaNPrrEdAl9c3fH3bIa+8aMVCNJLAA4LVHHXVcG+"
    "r7HeYntzjXubgQUFEnP9RoUW6labPWNUypDe3uE0xUK4bmptE45o/"
    "QJfri7EMPXLQm6+0xBtaw4Dr66ENUP/56x+KsFhiac2B5APMXohSga65/"
    "4CEU+Z1T4qnmTWo45c6xUYCpiBAD6BKSPun3fP+htR/"
    "DiDjqCwpYADADqHuPetLFkbUfaTNPa8FcRVlNQyM0p0COMSRT7awJrDu5NNQVkExls7/"
    "OZr5VwVREjxit/uwHDzywBiM+CAtgvObII48B09+3mE/"
    "JTSNBtvbm4KxnNPVACDFFoGRml9iqYeFNf9qbdOylZhUToU9AT9Gtfa3/"
    "7IZ9lFTeL4EFAOcCWh35xLdGbGdalpcoATAKOfE8mIUGsVjQZO7AiWXPoXeWDg7kAwt5gagsK1"
    "Zqs4GamX74gU+vTK0ixsDaEwA78shliukyZe3bIuYDlOgKSDJxzQ2ACkaMtMNmcMBqwM2+"
    "FFFYaSfAgBATmVjR38cmed9N69Y9utCu04IDVj5edsQRB7WJ3q4sv1EzDk0Bxk7lKTX6XU0stW"
    "MOPNVEjOEIlQJ6VwkoQ9iWKLpKaf3JVfs4kfy4BFY+VgDRgYcfeZYGX0CMMxXs4fnsH/"
    "IakgSdeheCTlQWAkSoUYmcJEKNIYEnnOb+FNFjFvQjBq2Ke51/uHHT77Ys9Ouy4IHl/"
    "z1nH3HEkR3guQQ8DcDBZHEwgOUgboGpBUCBYBhswJQwcRdEW63FVibaBqJZgp0Fq1kmu9Uyd8G"
    "6R5q7xtoYWkfa2oiVasFQR4OniXkRa0yDeZospgFMAZgiQFM67Y2YOAYwl3mG21nxw4boYWa+"
    "9wUPPXTPzD4qyBuP8RiP8RiP8RiP8RiP8RiP8RiP8RiP8Vgg4/"
    "8DeOwWSnyZJjwAAAAASUVORK5CYII=";

}  // namespace Base64

#endif /* FLUTTER_PLUGIN_CLIENT_WRAPPER_PLUGIN_IMAGE_H */
