# Инструменты

Copyright © 2024–2025 ООО «Открытая мобильная платформа».
Этот документ предоставляется в соответствии
с [Публичной лицензией Creative Commons с указанием авторства версии 4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Аврора SDK

Аврора SDK — это набор инструментов для создания, сборки, запуска, тестирования и отладки приложений. Аврора SDK имеет следующие варианты поставки:

- Аврора SDK (mb2) — окружение, поставляемое как виртуальная машина или Docker-образ, которое обеспечивает среду для сборки приложений. Сборка происходит кросс-компилятором gcc в окружении таргета. Для каждой архитектуры (x86_64, armv7hl, aarch64) эмулируется окружение сборки, таким образом инструменты сборки выполняют сборку так, как бы выполняли её нативно.
- Аврора BT (Build Tools) — инструменты для кросс-компиляции с помощью настроенного docker-образа. Сборка происходит кросс-компилятором gcc в окружении x86_64. Для сборки под архитектуры armv7hl и aarch64 в поставке имеется sysroot с библиотеками и исходными файлами для сборки.

Также в комплект Аврора SDK входят следующие инструменты:

- Аврора IDE (IDE) — интегрированная среда разработки, основанная на Qt Creator, для разработки приложений на языках С, C++ и QML для ОС Аврора с использованием компонентов Silica. IDE предоставляет продвинутый редактор кода с интеграцией системы контроля версий, управления проектами и сборками.
- ОС Аврора Emulator (эмулятор) — виртуальная машина, которая позволяет запускать приложения в ОС Аврора аналогично работе на реальном устройстве.
- Документация по архитектуре и API, примеры и шаблоны приложений.
- Утилиты для валидации и подписи пакетов, а также управления сторонними библиотеками (только для m2).

## Эмуляторы ОС Аврора

В состав Аврора SDK входит полноценный эмулятор ОС Аврора, который позволяет осуществлять полноценную отладку приложений, в том числе и на базе Flutter. Фактически из всего состава Аврора SDK именно эмулятор является основным компонентом. 

Эмулятор ОС Аврора работает в качестве виртуальной машины VirtualBox. При необходимости можно изменять параметры этой виртуальной машины. Ее запуск также осуществляется стандартными средствами VirtualBox.

При этом стоит учитывать, что управление виртуальным устройством (камера, геолокация, прочие датчики) осуществляется через Аврора IDE.

Управление камерой виртуальной машины описано в статье [developer.auroraos.ru/doc/sdk/app_development/emulation/camera#linux](https://developer.auroraos.ru/doc/sdk/app_development/emulation/camera#linux).

Управление геопозицией виртуальной машины описано в статье [developer.auroraos.ru/doc/sdk/app_development/emulation/positioning](https://developer.auroraos.ru/doc/sdk/app_development/emulation/positioning).

Управление датчиками виртуальной машины описано в статье [developer.auroraos.ru/doc/sdk/app_development/emulation/sensors](https://developer.auroraos.ru/doc/sdk/app_development/emulation/sensors).


Подробнее про управление эмуляторами ОС Аврора: [developer.auroraos.ru/doc/sdk/app_development/emulation](https://developer.auroraos.ru/doc/sdk/app_development/emulation) 

## Scratchbox2 (SB2)

Scratchbox2 (sbox2 или sb2) — это набор инструментов для кросс-компиляции, предназначенный для облегчения разработки приложений для систем на базе Linux.

В Linux при сборке программного обеспечения многие параметры определяются автоматически на основе хост-системы. Когда нужно собрать проект для встроенной цели (кросс-компиляция), большинство обнаруженных параметров оказываются неверны, так как конфигурация хоста не совпадает с конфигурацией встроенной цели. Scratchbox2 позволяет настроить «виртуальную» среду, которая имитирует целевую платформу, благодаря чему инструменты и исполняемые файлы работают так, как если бы они запускались непосредственно на этой системе.

По своей сути это набор сценариев bash, которые устанавливаются и обрабатываются в среде QEMU (среда виртуализации, похожая на VirtulBox), но при этом sb2 поддерживает множество различных архитектур, устанавливает все необходимые пути и переменные компоновщика и предоставляет другие полезные функции.

## MB2

Аврора Build Engine (MB2) — это среда сборки, которая предоставляет доступ к ряду инструментов, например, к Scratchbox2, в котором можно собрать специфичные для Linux-архитектуры исполняемые файлы с использованием эмуляции на QEMU.

MB2 — это обёртка со Scratchbox2 и другими утилитами, упрощающими сборку с помощью Build Engine.

С выходом ОС Аврора 5 появился новый инструмент, который должен заменить MB2, но на данный момент MB2 широко используется. Для разработки на Flutter мы будем использовать именно MB2.

mb2 выполняет подмножество команд сборки в контексте rpmbuild. Обычно он вызывается из QtCreator для выполнения фаз сборки проекта qmake/make.

Следует обратить внимание, что любые другие шаги сборки в файле .spec также будут выполняться. Инструмент будет искать .spec-файл в текущем каталоге rpm/. Если таких файлов несколько, можно указать целевой в параметре mb2 -s.

## Build Tools

apptool — это инструмент для кросс-сборки пакетов, независимый от mb2 и sb2. Он предоставляет другой набор функций и опций. В отличие от sb2, который имитирует нативную компиляцию для разных архитектур, apptool использует реальную кросс-компиляцию с помощью кросс-компиляторов.

Аврора SDK Build Tools (BT) — следующее поколение инструментов кросс-сборки приложения для ОС Аврора.

BT поставляется в Docker-образе, содержит в своём составе все необходимые инструменты сборки и имеет следующие особенности:

- Сформированы sysroots для всех поддерживаемых платформ (aarch64, armv7hl, x86_64).
- Имеет в составе кросс-компиляторы для всех поддерживаемых платформ.
- Имеет набор макросов для кросс-компиляции qmake проектов.
- Фиксирован и привязан к релизу ОС. Отсутствуют механизмы обновления и установки пакетов из репозиториев. Добавить инструменты можно, собрав их из исходников и сохранив как дополнительный слой для Docker-образа. Docker-образ поставляется в составе Аврора SDK в качестве движка сборки. Инструкция по установке Docker для различных ОС находится в разделе установка Docker.
- Основной инструмент сборки в ASBT — apptool.

В интегрированной среде разработки (IDE) при использовании инструментов ASBT есть вероятность столкнуться с определёнными проблемами и ограничениями, которые необходимо учитывать при работе, а именно:

- Docker Desktop либо служба Docker должна быть запущена;
- на MacOS при использовании в качестве workspace домашней папки появляется предупреждение безопасности и монтировании всей папки в Docker, а также запрашивается доступ к файлам.

## Таргеты PSDK

Так как для сборки приложений Flutter используется Platform SDK, то стоит отметить, что поддерживаются все популярные аппаратные платформы: 

* i486; x86_64 (начиная с версии 5.0): цель сборки — эмулятор из Application SDK;
* armv7hl: цель сборки — большинство устройств с ОС Аврора;
* aarch64: цель сборки — устройства на архитектуре armv8 (PinePhone, TrustPhone).

## Aurora CLI: Обзор

Aurora CLI — открытое консольное приложение от [Vitaliy Zarubin](https://github.com/keygenqt) и сообщества разработчиков ОС Аврора, которое упрощает работу с Аврора SDK, Aurora Platform SDK, Flutter SDK, взаимодействие с устройствами и эмулятором, а также выполнение частых операций.

Решаемые задачи:

- Установка компонентов инфраструктуры ОС Аврора (пока только MB2);
- Упрощение работы с эмулятором и устройствами (загрузка файлов, установка пакетов и другие операции);
- Упрощение работы с основными инструментами Platform SDK (подпись, валидация, установка пакетов и другие операции);
- И другие инструменты облегчающие работу в экосистеме ОС Аврора.

Aurora CLI доступно для большинства дистрибутивов Linux, так как оно разработано на Python 3.8. Ubuntu 20.04+, ALT Linux 10+ и других. Установка приложения доступна через pip управления пакетами Python.

## Aurora CLI: устройства и эмуляторы

С помощью одной Aurora CLI можно из консоли управлять эмуляторами и устройствами на ОС Аврора, например, для установки дополнительных пакетов, загрузки файлов или удаленного выполнения команд.

## Aurora CLI: управление SDK

Также одной командой можно скачать и установить все необходимые SDK как нативной разработки по ОС Аврора, так и разработки на Flutter.

## Aurora CLI: поддержка Flutter

Для Flutter можно не только устанавливать и настраивать все необходимые компоненты, но и выполнять полезные операции, например по форматированию кода проекта или генерации иконок приложения на основе предоставленного макета.

## Flutter CLI

Flutter CLI — консольная утилита из состава Flutter SDK от Google, которая позволяет выполнять все необходимые операции над Flutter-приложением — сборку, загрузку зависимостей, запуск, отладку, горячую замену. По факту разработку на Flutter можно осуществлять с помощью редактора уровня Блокнот и Flutter CLI.

В Аврора Flutter SDK используется расширенная версия Flutter CLI, дополнительно поддерживающая работу с эмулятором и устройствами ОС Аврора.

Чтобы не путать версию Аврора Flutter CLI от ОМП и оригинальную, рекомендуется настроить алиас (alias) flutter-aurora для разработки под Аврора. Таким способом вы сможете использовать несколько версий Flutter CLI (от Google и от ОМП) на одном компьютере.

Если сравнить Flutter CLI и Aurora CLI, то первый создан Google и предназначен для выполнения всех действий с проектом на Flutter, в то время как второй инструмент от сообщества позволяет управлять окружением и запускать частые операций при работе с ОС Аврора.

## Базовые команды Flutter CLI

В состав Flutter CLI входит большой набор готовых команд. Ниже приведен небольшой список полезных команд:

|Команда|Пример использования|Подробнее|
|---|---|---|
|build|`flutter-aurora build <DIRECTORY>`|Собирает приложение|
|clean|`flutter-aurora clean`|Удаляет результаты сборки приложения|
|gen-l10n|`flutter-aurora gen-l10n <DIRECTORY>`|Генерирует файлы для локализации приложения|
|install|`flutter-aurora install -d <DEVICE_ID>`|Устанавливаем приложение на подключенное устройство|
|logs|`flutter-aurora logs`|Показывает вывод приложения в консоль — логи работы|
|pub|`flutter-aurora pub <PUB_COMMAND>`|Позволяет работать в пакетами из репозитория [pub.dev](https://pub.dev)|
|screenshot|`flutter-aurora screenshot`|Делает скриншот запущенного приложения|
|test|`flutter-aurora test [<DIRECTORYDART_FILE>]`|Запускает автоматические тесты в проекте|

C помощью команды doctor можно проверить корректность настройки Flutter CLI:

```
flutter-aurora doctor
```

Эта команда при необходимости скачает недостающие компоненты и модули Flutter из интернет.

Если же требуется добавить реальное устройство (смартфон или планшет), то для этого можно использовать команду:

```
flutter-aurora devices add
```

Просмотр полной справки по всем возможностям Flutter CLI:

```
flutter-aurora -h
```

По каждой команде также можно получить расширенную справку, например по команде pub:

```
flutter-aurora pub -h
```

## Работа с проектом во Flutter CLI

С помощью командой строки можно выполнять все операции с проектом, включая создание, добавление новой новой платформы, запуск и отладку.

Чтобы создать новый проект с поддержкой ОС Аврора можно воспользоваться следующей командой:

```
flutter-aurora create --platforms=aurora --template=app --org=ru.aurora app_demo
```

Вместо `ru.aurora` требуется использовать домен вашей организации, а вместо `app_demo` название вашего проекта.

Добавить поддержку ОС Аврора в существующий проект можно командой:

```
flutter-aurora create --platforms=aurora --org={ORGNAME} .
```

`{ORGNAME}` — домен вашей организации в обратном порядке, например ru.omprussia. После выполнения этой команды будет создана папка aurora со всеми необходимыми нативными файлами — классами C++ для запуска библиотек Flutter и кроссплатформенного кода, ресурсы приложения и файлы конфигурации приложения ОС Аврора.

Запустить проект на подключенном устройстве (или эмуляторе) Аврора можно с помощью следующей команды:

```
flutter-aurora run -d aurora
```

Если проект еще не было собран, то данная команда автоматически запустит сборку и загрузку внешних пакетов/плагинов.

## Flutter CLI и VS Code

Flutter CLI является универсальным инструментов для выполнения всех операций, необходимых для разработки приложений на Flutter:

* Анализ.
* Сборка.
* Установка зависимостей.
* Упаковка и установка приложения на устройство/эмулятор
* Отладка.
* Горячая перезагрузка (hot reload).

VS Code использует Flutter CLI для решения данных задач, поэтому необходимо указать корректный путь до папки со средой Flutter для ОС Аврора. Все операции, которые можно выполнять с приложением Flutter через VS Code, можно выполнять с помощью командой строки.

## Использование VS Code

VS Code является одной из самых популярных сред разработки в настоящее время, которая при всей свой простоте является самым универсальным и функциональным редактором кода за счёт большого количества плагинов. Среди этих плагинов есть и инструменты разработки приложений Flutter, которые можно настроить для работы с ОС Аврора.

Базовую настройку VS Code для работы с Аврора Flutter SDK можно осуществить с помощью aurora-cli. Консольная утилита установит необходимые плагины (Dart и Flutter), а также пропишет корректный путь до Аврора Flutter SDK в плагине Flutter.

Вы также можете установить нужные плагины самостоятельно. После этого потребуется отредактировать файл с настройками VS Code, который обычно расположен в домашней папке пользователя .config/Code/User/settings.json. Вместо Code может быть другое имя, например, если вы используете Codium.

## Установить расширения в VS Code

Для разработки на Flutter в VS Code достаточно установить два расширения через Marketplace стандартными средствами VS Code — Dart и Flutter. Нужно использовать только официальные расширения от Dart Code.

Данные приложения работают с установленными версиями сред Dart и Flutter, поэтому перед первым запуском они предложат указать путь до папки, с установленными инструментами Flutter CLI.

## Скриншоты с VS Code

Для запуска приложения на эмуляторе требуется запустить эмулятор либо через Virtual Box, либо через Aurora Toolbox/CLI. Также эмулятор можно запустить из VS Code или Flutter CLI.

После этого вы можете открыть любой файл main.dart и нажать F5 (или кнопку Run в VS Code). Можно также настроить различные варианты запуска стандартными средствами VS Code.

На скриншотах показаны ключевые элементы управления процессом сборки и отладки приложения Flutter.

## Aurora Toolbox

В то время как Aurora CLI предназначен для работы через консоль, большинству начинающих разработчиков может быть проще работать через Aurora Toolbox — открытая графическая оболочка над функционалом Aurora CLI. Aurora Toolbox разрабатывается и поддерживается сообществом разработчиков ОС Аврора и доступна в первую очередь на Ubuntu 24.04+, работа на других версиях дистрибутивов Linux не гарантирована, но возможна.

Aurora Toolbox имеет основной функционал Aurora CLI в графическом исполнении:

- Установка/удаление Аврора SDK.
- Установка/удаление Platform SDK.
- Установка/удаление Flutter для ОС Аврора.
- Настройка VS Code для работы с Flutter для ОС Аврора.
- Управление устройствами и эмулятором ОС Аврора.

## Предназначение инструментов CLI

На слайде показано сравнение ключевых инструментов консольных инструментов, используемых при разработке приложений в ОС Аврора, чтобы проще было различать их друг от друга.
