# Особенности разработки для ОС Аврора

Copyright © 2024–2025 ООО «Открытая мобильная платформа».
Этот документ предоставляется в соответствии
с [Публичной лицензией Creative Commons с указанием авторства версии 4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Как портировать существующее приложение на ОС Аврора

Так как ОС Аврора является лишь одной из платформ, на которой работает Flutter, то существует высокая вероятность, что на ОС Аврора будут переноситься уже готовые приложения. 

Для портирования существующего приложения достаточно:

* добавить поддержку ОС Аврора в проект командой `flutter-aurora create --platforms=aurora`;
* настроить нативное приложение `aurora/main.cpp` для ОС Аврора (разрешения, иконки, прочие нативные особенности);
* при необходимости реализовать платформенный код некоторых плагинов.

Для добавления поддержки ОС Аврора в существующее приложение достаточно внутри папки с проектом выполнить команду в консоли: `flutter-aurora create --platforms=aurora --org={ORGNAME} .`

Эта команда добавит типовую папку для ОС Аврора со всеми файлами и ресурсами. 

## Доработка существующего проекта под ОС Аврора

После папки с нативным приложение ОС Аврора останется только внести небольшие изменения в файл desktop, установить иконки, название приложения и настроить сборку RPM-пакета.

Если в приложении использовались платформо-зависимые пакет, то может потребоваться реализовать их нативную часть для ОС Аврора, о чем будет рассказано в следующих лекциях. Отметим, что часть плагинов уже реализована для ОС Аврора. Список доступен по [ссылке](https://developer.auroraos.ru/doc/extended/flutter/support).

## Настройка файлов .desktop и .spec

Для корректной установки и работы нативного приложения в ОС Аврора, требуется настроить файлы *.desktop и *.spec:

* Обязательный .desktop-файл приложения описывает конфигурацию запуска установленного приложения:
  * Название в меню приложений на разных языках.
  * Иконка приложения.
  * Необходимые права доступа.
  * Путь до установленного приложения.
  * Тип приложения, организация и параметры работы с D-Bus (при необходимости).

* .spec-файл описывает правила сборки установочного пакета, в том числе: информацию о названии, описании, номере версии и номере релиза.

Подробное описание структуры файла .desktop доступно в [официальной документации](https://developer.auroraos.ru/doc/software_development/guidelines/rpm_requirements/desktop_requirements).

Подробное описание структуры файла .spec доступно в [официальной документации](https://developer.auroraos.ru/doc/software_development/guidelines/rpm_requirements/spec_requirements).

## Режим Отладки (Debug)

При разработке приложений на Flutter режимы Debug и Release имеют несколько ключевых отличий, которые влияют на производительность, отладку и оптимизацию программного кода.

Режим **Debug** предназначен для разработки и тестирования. Он включает в себя множество инструментов и настроек, которые упрощают отладку и анализ кода. Например, в этом режиме компилятор не оптимизирует код, что позволяет разработчикам видеть текущее состояние переменных, сообщения об ошибках и стек вызовов при возникновении исключений.

С другой стороны, режим **Release** предназначен для публикации приложения. В этом режиме код подвергается оптимизации, что повышает его производительность и уменьшает размер исполняемого файла. В частности, многие инструменты и отладочные функции отключены, что делает код быстрее и позволяет получить более отзывчивый пользовательский интерфейс. В режиме Release приложение обходится без дополнительных проверок и отладочной информации.

Другими словами, для разработки нужно использовать режим Debug, а для отправки пользователям — режим Release.

Во время работы приложение может выводить различную отладочную информацию, которая отображается в консоль отладки (при запуске через среду разработки) или терминал (при запуске из командной строки). Для включения режима вывода расширенной информации в консоль отладки (логирования, logging) можно передать параметр `-v` (verbose) команде `flutter-aurora run`.

## Отладка с помощью DevTools

DevTools — набор инструментов для Dart и Flutter, который позволяет отлаживать приложения и анализировать производительность.

Вот некоторые из возможностей, которые предоставляет DevTools:

* Анализ макетов пользовательского интерфейса и его состояние в приложении Flutter.
* Анализ проблемы с производительности UI в приложении Flutter.
* Профилирование загрузки центрального процессора для приложений Flutter или Dart.
* Профилирование сети для приложения Flutter.
* Отладка на уровне исходного кода для приложений Flutter или Dart.
* Анализ проблем с памятью в приложениях Flutter или Dart.
* Просматривать общую информацию о логах и диагностике запущенного приложения Flutter или Dart.
* Анализ кода и размера приложения.

DevTools можно использовать как совместно со средой разработки (в нашем случае с VS Code), так и отдельно — внутри браузера на базе Chromium (Google Chrome, Яндекс.Браузер, Edge и другие).

Для запуска DevTools через Google Chrome достаточно в консоли выполнить команду `flutter-aurora run` для запуска вашего приложения. После успешного запуска в консоли появится адрес для открытия DevTools в Google Chrome — строка вида http://127.0.0.1:9102?uri=http://127.0.0.1:40165/YWjdNlxOQfY=/

Если скопировать эту строку в буфер обмена и вставить в адресную строку Google Chrome, то откроется DevTools для вашего запущенного приложения.

## DevTools в Google Chrome

С помощью DevTools в Google Chrome доступен полный набор возможностей по работе с приложением, кроме радактирования его исходных кодов — можно не только просматривать и изменять параметры компонентов приложения, но и осуществлять отладку с помощью точек останова.

Изменять исходные коды можно во внешнем текстовом редакторе. При этом сохранение изменений на диск запустит процесс горячего обновления.

## Flutter Inspector

Flutter Widget Ispector — это инструмент для визуализации и исследования иерархии виджетов Flutter.  Инспектор помогает визуализировать и исследовать деревья виджетов Flutter, а также может использоваться для следующих целей:

* Понимание существующей компоновки компонентов на экране, что позволяет оптимизировать структуру и уровень вложенности элементов интерфейса.
* Выявлять проблем с компоновкой, что позволяет создавать более отзывчивый пользовательский интерфейс.

С помощью Flutter Inspector можно анализировать структуру приложения, проверять его состояние и находить узкие места в производительности, чтобы добиться оптимального результата. Это позволяет сделать процесс разработки более эффективным.

## Особенности отладки в VS Code

Отладка приложений Flutter в ОС Аврора ничем не отличается от отладки для других ОС — используются механизмы самого Flutter, который позволяют использовать точки останова, просматривать значения переменных и выполнять другие стандартные операции. Все это доступно при разработке на Flutter для ОС Аврора с помощью VS Code.

## DevTools в VS Code

После установки и настройки (указать путь до установленной Flutter SDK от ОМП) расширения Flutter в VS Code, в боковом меню появляется вкладка Flutter. На этой вкладке доступны все инструменты DevTools:

* Flutter Inspector.
* Профилировщики.
* Сетевые запросы и параметры соединения.
* Другие инструменты.

## DevTools, CPU Profiler

CPU Profiler в Flutter DevTools — это инструмент, предназначенный для анализа и оптимизации работы приложения, написанного на Flutter. Он предоставляет разработчикам возможность отслеживать производительность приложения в реальном времени, позволяя выявлять проблемные места в коде, которые могут привести к снижению общей производительности.

После захвата данных о приложения в определенный временной интервал происходит анализ данных, чтобы понять, какие части вашего кода работают неэффективно. CPU Profiler предоставляет информацию о различных статистиках, таких как количество вызовов функций, общее время выполнения и время, затрачиваемое на перейти между разными методами. 

Кроме того, CPU Profiler поддерживает функцию "flame graph" (пламенные графики), которая визуализирует использование процессора в виде графа, показывающего иерархию вызовов функций. Это упрощает анализ и позволяет легко идентифицировать функции, которые занимают наибольшее время и требуют оптимизации.

## DevTools, Performance

Основная цель Performance — обеспечить возможности для отслеживания производительности вашего Flutter-приложения, включая время рендеринга, частоту кадров, использование CPU и GPU, а также другие важные метрики. 

Одной из ключевых функций Performance является возможность просмотра временной линии (timeline), которая отображает события, происходящие в приложении в течение определенного временного интервала. Эта временная линия позволяет видеть, какие задачи выполняются, сколько времени они занимают, а также как они влияют на общее время отклика приложения. Здесь можно анализировать время, затраченное на различные этапы обработки, такие как создание виджетов, рендеринг и обработка жестов.

## DevTools, Memory

Memory в DevTools — это инструмент, который помогает разработчикам анализировать и управлять использованием памяти в приложениях. 

Регулярный мониторинг использования памяти и выполнение рекомендаций по оптимизации способствуют созданию более эффективных приложений, которые работают плавно и не вызывают негативных эмоций у пользователей.

## Горячая перезагрузка (Hot reload)

Горячая перезагрузка (hot reload) является огромным плюсом при разработке приложений на Flutter, так как сборка любого мобильного приложения по любую мобильную ОС (Аврора, Android, iOS) занимается длительное время. С помощью горячей перезагрузки разработчику достаточно сохранить изменения в файле и инструменты Flutter автоматически скомпилируют измененный класс в kernel binaries, отправят на устройство и перезагрузят приложение, полностью сохранив его состояние.

Это базовый механизм Flutter, который работает при использовании сборки в режиме Just-in-time (JIT), когда kernel binaries компилируется в машинные команды во время выполнения.

На низком уровне DartVM использует класс HotRunner, который компилирует код в промежуточный язык и отправляет на устройство, затем происходит определение фактических изменений и обновление интерфейса. HotRunner — это специальных компонент DartVM, отвечающий за динамическую компиляцию и обновление кода во время горячей перезагрузки.

## Горячая перезагрузка, ограничения

При работе с горячей перезагрузкой следует учитывать следующие ограничения:

* Отлично подходит для относительно простых интерфейсов и может сбоить при создании сложных интерфейсов с большим количеством сторонних компонентов.
* Перезагрузка может не происходить при изменении некоторых переменных и констант.
* Не поддерживаются изменения зависимостей в `pubspec.yaml`.
* Не поддерживаются изменения в нативном коде, так как он уже скомпилирован.

## Debug режим, возможные проблемы

Стоит учитывать, что Flutter для ОС Аврора еще находится в разработке, плюс сами инструменты могут показаться вам незнакомыми. Поэтому в случае проблем не стесняйтесь обращаться к сообществу разработчиков в Telegram.

В настоящий моменты некоторые из разработчиков могут столкнуться со следующими проблемами и неочевидными моментами:
- Во время разработки для эмулятора нужно включить режим разработчика в настройках виртуальной машины.

Инструкцию по включению режима отладки можно найти по ссылке: [developer.auroraos.ru/doc/sdk/app_development/work/launch/device](https://developer.auroraos.ru/doc/sdk/app_development/work/launch/device).

## Особенности DevTools для Авроры

Стоит помнить, что DevTools работает с кроссплатформенной частью приложения в среде Dart, поэтому его функционал аналогичен для всех платформ, на которых работает Flutter. Специфических особенностей DevTools для ОС Аврора не существует.

Отдельно стоит добавить, что DevTools никак не взаимодействует с нативной частью приложения и не поможет в отладке платформенного кода.

## Известные проблемы DevTools

При разработке Flutter-приложений под ОС Аврора начинающие разработчики могут сталкиваться со следующими проблемами:

- Приложение не запускается, так как не найдено устройство. Решение: запустить эмулятор вручную до запуска приложения.
- Зависла сборка. Решение: перезапустить виртуальную машину сборки, если не помогло обновить PSDK.
- Устройство не отображается. Решение: повторно подключить устройство, проверить подключение по ssh, удалить и добавить во Flutter CLI.

При обнаружении проблемы во Flutter SDK от ОМП вы можете отправить письмо на почту [dev-support@omp.ru](mainto:dev-support@omp.ru).
