# Плагины

Copyright © 2024–2025 ООО «Открытая мобильная платформа».
Этот документ предоставляется в соответствии
с [Публичной лицензией Creative Commons с указанием авторства версии 4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Юзабилити обычной разработки на Flutter

Стоит отметить, что Flutter имеет обширную открытую экосистему, в которой разработчики могут находить и использовать множество готовых инструментов и компонентов, упрощающих процесс создания приложений. Эти компоненты создаются сообществом и могут включать различные виджеты и утилиты, адаптированные под конкретные задачи. Использование сторонних компонентов значительно ускоряет разработку, позволяя сосредоточиться на разработке нового функционала.

Готовые компоненты Flutter называются пакетами.

Самым простым способов добавления пакетов в ваше Flutter-приложение является команда:

```
flutter pub add <ПАКЕТ>
```

где `<ПАКЕТ>` — это название стороннего компонента, который вы хотите добавить.

По умолчанию все пакеты загружаются с сервиса [pub.dev](https://pub.dev), официального репозитория для пакетов Dart и Flutter. Этот сервис предлагает разработчикам широкий выбор компонентов, которые вы можете искать по категориям, популярности или другим критериям. Каждый пакет сопровождается описанием, документацией, примерами и ссылкой на исходные коды.

Среди пакетов встречаются и такие, которые содержат нативную реализацию и используют возможности целевой операционной системы. Такие пакеты называются плагинами.

Итак, основная задача сторонних пакетов — ускорить разработку приложения за счёт переиспользования готовых компонентов. Внутри самого Flutter также есть модули, которые устанавливаются по аналогии с пакетами, что позволяет гибко управлять зависимостями и уменьшать размер финального приложения, используя в нем только необходимый минимум зависимостей.

## Добавление пакетов в pubspec.yaml

Пакеты в проект можно добавлять вручную через изменение файла `pubspec.yaml`, указав название пакета и нужную версию в разделе `dependencies`:

```
dependencies:
  path_provider: ^2.1.5
```

Нужную версию пакета можно указать следующим образом:
* Конкретная версия. Пример: 2.1.5
* Минимальная версия: Пример: ^2.1.5
* Диапазон версий: Пример: >=2.1.5 <2.5.0

Подробнее добавление пакетов в проект можно изучить в [официальной документации Flutter](https://docs.flutter.dev/packages-and-plugins/using-packages).

## Готовые компоненты Flutter

Готовые компоненты Flutter можно разделить на 3 вида:

* **Платформо-независимые пакеты** — эти компоненты работают только внутри экосистемы Flutter и не обращаются к нативным библиотекам или механизмам операционной системы. Например, новые виджеты и стили позволяют создать визуально привлекательные и удобные пользовательские интерфейсы. Они могут включать как стандартные элементы (такие как кнопки, текстовые поля и списки), так и более сложные компоненты, такие как графики и анимации. Эти виджеты адаптируются к различным платформам, сохраняя единый код, что делает их очень удобными для кроссплатформенной разработки. Также платформо-независимые библиотеки предоставляют возможности для обработки данных и выполнения вычислений. Это может включать в себя библиотеку для работы с JSON, для выполнения математических операций или для доступа к API.
* **Платформо-зависимым плагины** — это пакеты, которые обеспечивают взаимодействие между приложением и аппаратной частью устройства. Используя плагины, разработчики могут получать доступ к таким функциям, как камера, GPS, сенсоры и другим элементам, которые напрямую зависят от устройства, на котором работает приложение. Плагины обеспечивают необходимую связку между средой выполнения Dart и нативными библиотеками операционных систем.
* **Частично-зависимые пакеты** — промежуточный вариант между вышеперечисленными типами. Эти компоненты зависят от платформо-зависимых плагинов, но могут использоваться в проекте как платформо-независимые пакеты.

## Для чего нужны

Разработчики на Flutter должны всегда помнить о возможности использовать тысячи готовых компонентов в своих проектах с помощью сервиса pub.dev, что позволяет сократить сроки разработки и улучшить качество конечного продукта.

При рассмотрении структуры Flutter-приложения можно выделить несколько ключевых блоков:

* **Пользовательский интерфейс** — Flutter предлагает разработчикам множество сторонних виджетов с помощью **пакетов**. Это позволяет создать единообразный стиль на различных платформах. Кроме того, существуют пакеты, которые упрощают процесс верстки. Разработчики могут использовать готовые решения для создания адаптивных интерфейсов, которые корректно отображаются как на мобильных устройствах, настольных компьютерах, так и в веб-браузерах.
* **Бизнес-логика** — в разработке приложений часто используются определенные шаблоны проектирования, такие как MVVM или BLoC. Для этих целей на pub.dev доступны готовые **пакеты**. Они упрощают управление состоянием и помогают сделать код более организованным и структурированным, что, в свою очередь, облегчает его поддержку и тестирование.
* **Работой с данными и сетью** — доступно множество готовых **пакетов и плагинов**, которые упрощают взаимодействие с базами данных и сетевыми сервисами. Разработчики могут использовать библиотеки для работы с SQLite, Firebase или другими системами хранения данных, а также интегрировать внешние сервисы по REST и gRPC.
* **Взаимодействие с железом и операционной системой** — Flutter предоставляет готовые компоненты для выполнения частых задач, таких как работа с камерами, сенсорами, геолокацией и другими функциями устройства. Такие **плагины** всегда зависят от операционной системы и требуют нативной реализации.

Таким образом, разработчики на Flutter обладают мощным инструментарием, благодаря библиотекам и пакетам, доступным на pub.dev. Используя готовые решения для каждого из блоков приложения, они могут эффективно и быстро создавать качественные кроссплатформенные приложения, которые будут радовать пользователей.

## Плагины, состав, ограничения, концепция OpenSource и приглашение присоединиться

При разработке пакетов для Flutter важно различать их виды, так как это влияет на возможность их использования в ОС Аврора. Пакеты делятся на три основные категории: платформо-независимые, платформо-зависимые и частично-зависимые.

Платформо-независимые пакеты реализованы на языке Dart и функционируют на любых платформах без необходимости написания нативного кода. Такие пакеты могут включать:

- Новые виджеты и стили, расширяющие стандартный набор Flutter.
- Библиотеки обработки данных и вычислений, выполняющие сложные задачи без обращения к платформе.
- Различные математических вычисления и алгоритмы обработки данных.

Платформо-зависимые пакеты взаимодействуют с операционной системой:

- Взаимодействие с железом и доступ к файловой системе, такие как работа с камерой или датчиками устройства.
- Использование специфичных API ОС, требующее написания нативного кода.

Частично-зависимые пакеты сами по себе не зависят от платформы, но зависят от сторонних платформо-зависимых пакеты.

Платформо-независимые пакеты можно использовать в ОС Аврора без каких-либо доработок, поэтому мы не будем далее рассматривать их создание, а сфокусируемся на платформо-зависимых компонентах, так как это может потребоваться при портировании существующих приложений на ОС Аврора.

## Плагины, состав, ограничения

Плагин представляет собой платформо-зависимый пакет, который позволяет разработчикам использовать нативные возможности операционной системы и взаимодействовать с железом. Это особенно важно, поскольку Flutter является кроссплатформенным. 

Плагины во Flutter имеют две ключевые части. Первая — это платформо-независимая, написанная на языке Dart. Она отвечает за бизнес-логику и взаимодействие с пользовательским интерфейсом. На этом уровне разработчики могут писать код, который будет работать на любых устройствах, поддерживающих Flutter. 

Вторая часть плагина — это платформо-зависимый нативный код, который написан на языках, поддерживаемых целевой платформой. Например, для ОС Аврора это будет C++. Нативный код обеспечивает прямой доступ к функционалу операционной системы, а также к нативным библиотекам, которые могут не быть доступны через Dart.

Взаимодействие между кодом на Dart и нативной частью происходит с помощью механизмов DartVM. Эти механизмы обеспечивают эффективное и безопасное взаимодействие между Dart-кодом и нативными API.

Отдельно стоит упомянуть о специфике работы с плагинами в контексте операционной системы Аврора. Поскольку данная ОС не поддерживается Flutter официально, разработчики сталкиваются с определёнными трудностями при работе с плагинами из pub.dev. Такие плагины не имеют необходимой нативной реализации для корректной работы на Авроре. Это означает, что для полноценного использования плагинов разработчику необходимо самостоятельно создавать нативную реализацию.

## Концепция OpenSource

Концепция Open Source, или открытого исходного кода, представляет собой важную составляющую современного программного обеспечения и разработки. Она подразумевает, что программные продукты, такие как пакеты и плагины для Flutter, доступные на платформе pub.dev, распространяются под открытыми лицензиями. Это позволяют любому желающему просматривать, изменять и делиться исходным кодом, способствуя развитию и улучшению программного обеспечения.

Практически все пакеты и плагины, доступные на pub.dev, имеют открытые лицензии, что создает активное сообщество. Однако стоит быть внимательным к условиям лицензирования, особенно если речь идет о GPL (General Public License). Эта лицензия требует, чтобы любые производные работы, включая весь проект, были выложены в открытый доступ. Поэтому перед тем как использовать плагины или пакеты, лицензированные под GPL, разработчикам необходимо тщательно рассмотреть, готовы ли они поделиться своим кодом с сообществом. В противном случае им следует выбирать другие пакеты, которые распространяются под более гибкими лицензиями.

Что касается доработок Flutter SDK от ОМП, а также дополнительных примеров и плагинов, предназначенных для операционной системы Аврора, они также распространяются под открытыми лицензиями. Это позволяет сообществу вносить свой вклад в развитие экосистемы. Опубликовав свой плагин, разработчик оказывает поддержку сообществу.

## Какие есть плагины

Список самых популярных плагинов можно найти на сайте pub.dev, открыв адрес [https://pub.dev/packages?q=sdk%3Aflutter&sort=downloads](https://pub.dev/packages?q=sdk%3Aflutter&sort=downloads) и выбрать параметры сортировки — по количеству загрузок, по количеству лайков или рейтингам. Стоит учитывать, что и компоненты самого Flutter также размещены на pub.dev, поэтому самые загружаемые пакеты это именно части самого фреймворка.

## Пример пакета, auto_size_text

Пакет auto_size_text предоставляет виджет, который динамически изменяет размер текста, чтобы он уместился в заданную область:

`flutter-aurora pub add auto_size_text`

Подробнее о пакете можно почитать на его странице: [https://pub.dev/packages/auto_size_text](https://pub.dev/packages/auto_size_text).

## Пример пакета, cached_network_image

Пакет cached_network_image предоставляет виджет, позволяет кешировать изображения, загружаемые из сети, чтобы они не скачивались при повторном обращении:

`flutter-aurora pub add cached_network_image`

Пример использования, включая индикатор загрузки и виджет ошибки:

```
CachedNetworkImage(
        imageUrl: "http://via.placeholder.com/350x150",
        placeholder: (context, url) => CircularProgressIndicator(),
        errorWidget: (context, url, error) => Icon(Icons.error),
     ),
```

Подробнее о пакете можно почитать на его странице: [https://pub.dev/packages/cached_network_image](https://pub.dev/packages/cached_network_image).

## Пример пакета, DivKit

Пакет DivKit от Яндекс предоставляет движок создания интерфейса пользоватля с помощью веб-сервера, убирая необходимость переустанавливать приложение:

```
flutter-aurora pub add divkit
```

DivKit — Фреймворк для server-driven UI с открытым кодом. То есть разработчик описывает элементы, состояния и анимации на бекенде — и они передаются с сервера без привязки к версии приложения. Для обновления интерфейса приложения нет необходимости устанавливать новую версию.

Примеры и документацию можно найти по адресу [https://divkit.tech/ru/](https://divkit.tech/ru/).

## Пример пакета, Flame

Пакет Flame предоставляет движок для разработки игр с помощью Flutter:

```
flutter-aurora pub add flame
```

Данный движок отлично подходит для быстрого создания простых игр.

Примеры проектов и документацию можно найти по адресу [https://flame-engine.org/](https://flame-engine.org/).

## Какие есть плагины

Так как Flutter из коробки предоставляет лишь базовую функциональность, но есть ряд незаменимых плагинов, которые нужны практически каждому реальному приложению:

- path_provider — позволяет получить пути к пользовательским папкам в системе, например к папке "Документы" или "Загрузки".
- shared_preferences — используется для хранения настроек приложения между перезапусками.
- url_launcher — позволяет открывать внешние приложения или веб-ссылки из вашего приложения.

Данные плагины уже доступны для ОС Аврора.

## Полезные плагины

Менее востребованные, но не менее важные плагины, которые также доступы для ОС Аврора:

- sqlite3 — позволяет использовать локальную БД SQLite для хранения данных. Это обёртка над нативной библиотекой SQLite.
- image_picker — выбор изображения из галереи устройства.
- file_selector — выбор файла из памяти устройства.
- flutter_secure_storage — платформенное зашифрованное хранилище данных (логины, пароли и другая секретная информация).

## Как искать

Если говорить про разработку приложений для ОС Аврора, то в первую очередь нужно познакомиться с уже доступными платформо-зависимыми плагинами от ОМП и сообщества. Список поддерживаемых плагинов постоянно расширяется на основе обратной связи от бизнес-заказчиков и партнером ОМП. Также сторонние компании и отдельные разработчики помогают портировать плагины на ОС Аврора.

Помимо репозиториев ОС Аврора требуется обязательно научиться работать с официальным хранилищем плагинов pub.dev от Google. Там вы можете найти большое количество платформо-независимых плагинов, а также при необходимости добавить нативную реализацию для ОС Аврора.

## Где искать

Готовые пакеты и плагины можно найти по следующим адресам:

* Плагины для ОС Аврора от ОМП: [developer.auroraos.ru/doc/extended/flutter/support/official_packages](https://developer.auroraos.ru/doc/extended/flutter/support/official_packages) 
* Плагины для ОС Аврора от сообщества: [developer.auroraos.ru/doc/extended/flutter/support/community_packages](https://developer.auroraos.ru/doc/extended/flutter/support/community_packages) 
* Официальный репозиторий пакетов, но для работы в ОС Аврора может потребоваться написать платформенную часть: [pub.dev](https://pub.dev)


## Подключение платформенной части плагина для ОС Аврора

Для подключения платформенной части плагина нужно добавить ссылку на репозиторий с нативным кодом для ОС Аврора (на примере плагина path_provider):

```
dependencies:
  path_provider: ^2.0.15
  path_provider_aurora:
    git:
      url: https://gitlab.com/omprussia/flutter/packages.git
      ref: aurora-path_provider_aurora-0.6.0
      path: packages/path_provider_aurora
```

И выполнить требования плагина для работы с платформой, например добавление необходимых разрешений в *.desktop файл приложения:

```
Permissions=UserDirs
```

## Конфликты между зависимостями

Большинство пакетов (особенно популярных) со временем обновляется и улучшается — так появляются новые версии. При этом одни пакеты могут использовать другие пакеты в качестве зависимостей. В результате сразу несколько пакетов в проекте могут ссылаться на одну внешнюю зависимость.

Предположим, что в проекте необходимо использовать сразу два пакета, например, some_package и another_package, и оба эти компонента зависят от пакета url_launcher. Но some_package зависит от самой последней версии url_launcher, больше 5.4.3 (должна быть установлена крайняя версия 6.3.1), а another_package жестко привязан к url_launcher версии 5.4.0. Это приводит к конфликту версий. Чтобы избежать подобных проблем, можно в самих пакетах указывать диапазоны совместимых версий сторонних компонентов, а не конкретные цифры. Об это будет рассказано в следующем разделе.

## Устранение конфликтов

Даже если some_package и another_package используют разные версии url_launcher, они все еще могут использовать url_launcher в одном проекте. В этой ситуации конфликт можно разрешить, переопределив зависимости в файле pubspec.yaml, что заставит использовать конкретную версию url_launcher.

Например, чтобы принудительно использовать версию url_launcher 5.4.0, требуется внести изменения в файл pubspec.yaml:

```
dependencies:
  some_package:
  another_package:
dependency_overrides:
  url_launcher: '5.4.0'
```

Чтобы уменьшить вероятность конфликтов в настройках зависимостей пакета или приложения можно указывать диапазон версий для зависимого компонента:

```
dependencies:
  some_package: '>=1.2.0 <2.0.0'
```

Использование диапазонов версий позволяет указать, что пакет совместим с несколькими версиями зависимости, что снижает вероятность конфликтов при интеграции различных библиотек. Таким образом, при обновлении или добавлении пакетов, проект будет работать с подходящими версиями внешних зависимостей. Это важно учитывать, так как экосистема Flutter активно развивается и новые версии популярных библиотек выходят очень часто.

## Ошибки совместимости, DevSupport

Стоит еще раз напомнить, что Flutter официально не поддерживает ОС Аврора. ОМП развивает Flutter c её поддержкой параллельно основной версии. pub.dev предоставляет плагины только для официально поддерживаемых платформ.

Плагины, которым не нужна платформенная часть, заработают в ОС Аврора автоматически. Если потребуется платформенная реализация, то следует проверить наличие готовой реализации от ОМП или сообщества разработчиков Аврора. Иногда может потребоваться написать плагин самостоятельно, о чем будет рассказано в следующей лекции.

ОМП и сообщество работают над увеличением количества поддерживаемых плагинов.

Сообщество разработчиков ОС Аврора: [t.me/aurora_devs](https://t.me/aurora_devs).
Поддержка разработчиков: [dev-support@omp.ru](mailto:dev-support@omp.ru).
