# Введение

Copyright © 2024–2025 ООО «Открытая мобильная платформа».
Этот документ предоставляется в соответствии
с [Публичной лицензией Creative Commons с указанием авторства версии 4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## О чём курс

Данный курс является кратким путеводителем по разработке мобильных приложений на Flutter для ОС Аврора и охватывает следующие темы:

- История Flutter.
- Устройство и принципы работы Flutter.
- Особенности Flutter в ОС Аврора.
- Сравнение Flutter и Qt.
- Инструменты разработки на Flutter для ОС Аврора.
- Использование плагинов Flutter.
- Создание плагинов Flutter для ОС Аврора.
- Портирование существующих приложений Flutter на ОС Аврора.

## Цели курса

Главная задача — собрать в одном месте всю необходимую информацию для начала разработки приложений для ОС Аврора на Flutter.

Цели курса включают следующие важные пункты:

- Изучить устройство Flutter.
- Познакомиться с особенностями ОС Аврора.
- Научиться устанавливать и настраивать среду разработки на Flutter под ОС Аврора.
- Освоить инструменты командой строки для работы со средами разработки ОС Аврора и Flutter.
- Научиться использовать и создавать плагины Flutter на ОС Аврора.
- Научиться портировать существующие проекты на ОС Аврора.

## Как работать с материалом

Рекомендуем использовать презентации как основу для ваших лекционных занятий.

Задания в курсе помогут проверить и закрепить полученные знания во время зачетов и экзаменов.

Лабораторные работы обеспечат возможность практического применения теории в самостоятельных условиях.

Представленные в курсе примеры приложений станут основой для курсовых проектов.

## Как выполнять задания

В конце отдельных лекций будут предложены задания в виде тестов с одним или несколькими правильными ответами.

Для выполнения практических заданий настоятельно рекомендуем использовать Ubuntu не ниже версии 22.04.

## Помощь и поддержка

У Открытой Мобильной Платформы есть команда поддержки, а также активное сообщество разработчиков в Telegram. По всем вопросам вы можете обращаться на [edu@omp.ru](mailto:edu@omp.ru), а следить за анонсами — в канале [t.me/omp_edu](https://t.me/omp_edu).

## Появление Flutter

JavaScript является основным языком для веб-разработки, хотя он изначально для этого и не создавался. Как следствие, в программах на JavaScript бывает много конструкций, которые во время выполнения имеют очень низкую производительность. Плюс в JavaScript есть и другие ограничения, из-за которых сложно создавать большие высокопроизводительные веб-приложения.

Марк Миллер из Google писал, что в JavaScript есть «фундаментальные изъяны», которые невозможно исправить. Так появилось предложение создать новый язык для веб-разработки, который назвали Dart (перевод с английского — дротик). Стоит заметить, что очень похожую цель преследовали создатели языка TypeScript, который, в отличие от Dart, обрёл очень широкую популярность в веб-разработке.

Основная цель проекта Dart заключалась в разработке языка, который с одной стороны имел бы высокую производительность, а с другой — возможность компиляции в JavaScript, что обеспечивало обратную совместимость с существующими веб-браузерами.

Над созданием Dart и связанных с ним инструментов работала команда, стоявшая за JS-движком Google V8 и веб-браузером Chrome. В дальнейшем они они в качестве эксперимента и создали Flutter.

## Эволюция Flutter

В 2011 году разработчики Google V8 начали разрабатывать Dart как замену медленного JavaScript. Это должно было решить проблему производительности веб-приложений.

В 2013 году вышла стабильная версия языка Dart 1.0 и инструментов, что позволило разработчикам писать веб-приложения непосредственно на Dart вместо JavaScript.

В 2014 году команда Dart провела значимый эксперимент — код движка Google Blink (форк WebKit), отвечающий за отрисовку графики был заменен с C++ на Dart. Так появился прототип Flutter, который вскоре станет полноценной платформой.

В 2015 году на Dart Developer Summit была представлена предварительная версия Flutter, что позволило разработчикам начать работу с новой технологией и получить первую обратную связь от внешних разработчиков.

В 2018 году вышли стабильные версии Flutter 1.0 и Dart 2.0, что стало отправной точкой для взрывного роста интереса к Flutter.

## Популярность Flutter

Flutter появился на рынке, где уже доминировали 3 кроссплатформенных инструмента: Xamarin, ReactNative, PhoneGap (Apache Cordova) и Ionic на его основе. Существующий уже более 30 лет фреймворк Qt рано выбыл из гонки мобильных кроссплатформенных фреймворков. И так Flutter появился последним, однако благодаря высокой производительности, простоте и стабильности быстро завоевал популярность. Приложение на PhoneGap является по сути веб-страницей, запущенной внутри встроенного в приложение веб-браузера. Xamarin предоставляет обертки над нативными методами C/C++, а ReactNative дает возможность управлять нативными компонентами из кода JS.

Flutter предоставляет более изолированную среду, похожую на PhoneGap, но обеспечивает очень высокую производительность пользовательского интерфейса.

За последние несколько лет Flutter стал самым популярным кроссплатформенным фреймворком для разработки мобильных приложений.

## Как работает Flutter

Что было у Google на момент появления Flutter:

- Кроссплатформенный JS-движок Google V8, один из лучших движков в настоящее время, обеспечивает самую высокую производительность. Используется не только в веб-браузерах, но и как основа для веб-серверов на базе node.js.
- Кроссплатформенный язык Dart и инструменты компиляции в JS. Эти инструменты позволяют конвертировать код на Dart в JavaScript, что обеспечивало совместимость с существующими веб-браузерами.
- Кроссплатформенный веб-движок Google Blink, который используется для рендеринга HTML-страниц и обеспечивает отрисовку и управление объектами на экранах мобильных устройств и ПК.
- Команда разработчиков Google, которая включала в себя экспертов по V8, Dart и Blink.

По факту Flutter появился как переосмысление и переработка V8, Dart и Blink. 

Для запуска приложения на Flutter сначала запускается нативное приложение (или runner), которое инициализирует движок Flutter, использующий возможности графических библиотек (Impeller или Skia) для отрисовки интерфейса. Это обеспечивает высокую производительность и гибкость при отображении сложных элементов пользовательского интерфейса. 

Исходный код нативного приложения (runner) генерируется при создании проекта Flutter, в будущем дополнительно можно включить поддержку и новых платформ (доступных для Flutter SDK), используя консольную команду `flutter create --platforms=<values> .`, где вместо `<values>` можно использовать ios,android и другие поддерживаемые платформы.

## Эксперимент по созданию Flutter

Разработчики Google, имея за плечами опыт разработки движка V8, создали сначала DartVM, как среду для выполнения кода на Dart и взаимодействия с ОС, подружили эту среду с графической библиотекой Skia и реализовали на Dart механизмы отрисовки пользовательского интерфейса.

Всё очень похоже на веб-приложения, но только вместо HTML и CSS интерфейс описывается с помощью виджетов Flutter на языке Dart, который также используется при написании логики вместо JavaScript.

## Flutter для разных ОС

Оригинальный Flutter от Google обеспечивает гибкость, что позволяет разрабатывать приложения, которые работают на различных операционных системах, включая iOS, Android, Linux, Windows, macOS, а также встраиваемых системах и веб-браузерах. Расширенная версия Flutter SDK от Открытой Мобильной Платформы также поддерживает ОС Аврора.

Для запуска внутри веб-браузера Flutter-приложение может быть либо скомпилировано в традиционные JS/HTML/CSS, либо запущено внутри DartVM, которая поставляется в виде библиотеки WebAssembly.

При запуске в качестве мобильного и десктопного приложения код Flutter-фреймворка является библиотекой для нативного приложения и поставляется вместе с приложением.

## Отрисовка графики, Skia

При создании Flutter в качестве графического движка была использована библиотека Skia, купленная Google в 2005 году. 

Skia является кроссплатформенной, написана на C++ и обеспечивает высокопроизводительную отрисовку 2D-графики. 

Skia предоставляет высокоуровневые механизмы отрисовки примитивов и графики. Высокая производительность достигается за счёт того, что вместо предварительной отрисовки одного кадра (изображение в формате BMP, поверх которого рисуются новые элементы), все команды рисования преобразуются в шейдеры (низкоуровневые программы для графической карты на C-подобном языке) и логика рисования выполняется самой графической картой. 

То есть вместо алгоритма "нарисовать кадр в виде одной картинки, а затем показать это изображение на экране" используется подход "преобразовать все команды рисования в команды графической карты". Это позволяет генерировать кадры не центральным процессором в оперативной памяти компьютера, а передать эту работу графической карте. Данный подход позволяет получить очень высокую производительность.

Поддерживаются такие API для взаимодействия с графической картой, как OpenGL, Vulkan и Metal.

## Skia, узкие места отрисовки

Одна из проблем, с которой сталкиваются разработчики Flutter, — подергивания интерфейса при первой отрисовке экрана. Это связано с тем, что при первом запуске происходит преобразование команд рисования в шейдеры, что занимает время и особенно заметно для сложного пользовательского интерфейса. Анимации могут подёргиваться.

Разработчики могут использовать "прогрев" шейдеров при сборке приложения, чтобы избежать подобного эффекта в будущем. Это особенно важно при создании сложных интерфейсов. Во время "прогрева" специальный инструмент заранее проходит по всем виджетам и страницам приложения, чтобы скомпилировать шейдеры ДО запуска приложения.

Однако разработчики Flutter уже трудятся над новой библиотекой Impeller, которая уже используется в iOS и должна заменить в ближайшем будущем Skia на Android и MacOS. В Impeller не потребуется "прогрев" шейдеров и реализуется [поддержка 3D](https://github.com/flutter/engine/blob/main/docs/impeller/Flutter-GPU.md).

## Параллелизм команд в Dart, термины

При дальнейшем рассмотрении темы параллельного выполнения команд в языке Dart требуется дать определение следующих ключевых терминов:

* Асинхронность — концепция программирования, позволяющая выполнять операции параллельно, не блокируя основной поток выполнения.
* Квазимногопоточность — это способ выполнения команд Dart параллельно, который внешне похож на многопоточность, но в основе этого механизма лежит однопоточная модель выполнения с асинхронными операциями и циклом событий.
* Событие — это объект, который представляет собой изменение состояния или действие, возникающее в программе и служащее для уведомления слушателей о необходимости обработки данного изменения.
* Микрозадача — это единица работы, которая выполняется в рамках цикла событий и используется для обработки асинхронных операций с высоким приоритетом.

Подробнее про параллелизм в Dart можно узнать в лекции [education.yandex.ru/handbook/flutter/article/dart-concurrency-izolyaty](https://education.yandex.ru/handbook/flutter/article/dart-concurrency-izolyaty).

## Параллелизм команд в Dart, Future

Future является ключевым механизмов для реализации асинхронности в Dart. Его непрямыми аналогами можно назвать Promise в JavaScript и Task в C#.

Future — это объект, представляющий значение или ошибку, которые будут доступны в будущем. Он используется для работы с однократными асинхронными операциями (например, загрузка данных с сервера или чтение файла).

Future реализуется с помощью соответствующего класса в Dart, который реализует набор нужных свойств и методов для управления блоком команд, а также формирования из них конвейеров с помощью методов then() и catchError().

Future может иметь состояния «выполнена» (Completed) и «не выполнена» (Uncompleted). Также выполнение Future может быть «отложено» с помощью метода delayed().

Пример Future:
```
Future(() => print('Hello world'))
```

## Квазимногопоточность

Dart — однопоточный язык программирования, а Flutter использует Dart. То есть Dart исполняет одновременно только одну инструкцию вашего кода за раз. Такое последовательное выполнение инструкций означает, что текущая операция не может быть прервано другой инструкцией.

Однако, Dart все-таки современный язык, а большинство центральных процессоров сейчас имеет несколько вычислительных ядер, поэтому Dart позволяет выносить фоновые задачи в отдельные квазипотоки, которые называются изолятами (isolate). Каждый изолят имеет свое изолированное адресное пространство в куче (heap) адресной памятия и не может напрямую взаимодействовать с другими изолятами. Но самое главное — изоляты могут выполняться как в отдельных потоках операционной системы, так и в уже созданных. Это позволяет выгружать длительные операции в отдельные потоки операционной системы и задействовать дополнительные ядра центрального процессора для ускорения вычислений.

Взаимодействие изолятов происходит с помощью портов, по аналогии с сетевыми запросами — каждый изолят открывает порты на получения (ReceivePort) и отправки (SendPort) данных, а другие изоляты могут их использовать для обмена сообщениями.

Подробнее про изоляты можно изучить в официальной документации: [docs.flutter.dev/perf/isolates](https://docs.flutter.dev/perf/isolates).

## Очереди событий и микрозадач

Помимо квазипоточности Dart поддерживает и асинхронность, доступную во многих других современных языках программирования (JavaScript, TypeScript, Go, Kotlin, C# и другие). Асинхронность — это способ выполнения инструкций, когда приложение не блокируется во время выполнения фоновых операций. 

За выполнение инструкций в Dart отвечает компонент "цикл по обработке событий" (Event Loop). При запуске приложения Dart создается главный (main) изолят и инициализируется 2 очереди, работающие по модели "первый вошел — первый вышел" (first in first out, FIFO):

- Event — очередь событий;
- MicroTask — очередь микрозадач.

После этого уже в главном изоляте выполняется метод main() и запускается бесконечный цикл по обработке событий (знакомый Event Loop). За управление логикой работы Event Loop отвечает сам Dart. Если активный поток команд завершается, то Dart передает управление в Event Loop для выполнения одной микрозадачи или обработки одного события по следующему алгоритму:

- если в очереди MicroTask есть микрозадачи, то выполнить первую из них и выйти из Event Loop;
- если в очереди Event есть события, то запустить обработать первое событие в очереди и выйти из Event Loop.

Таким образом за раз из очереди убирается по одной микрозадачи или события. Приоритет отдается микрозадачам — обработка событий будет происходить только после выполнения всех микрозадач.

Помимо самих событий в очередь Event также попадают так называемые "обещания" (Future), операции, результат которых вернется в будущем. Когда Event Loop встречает Future в очереди Event, то сначала проверяется статус этого объекта (ошибка, завершено с успехом или не завершено) и если не завершено, то снова возвращает его в очередь. Если Future завершено (с успешом или ошибкой), то результат возвращает в тот поток команд, где Future был создан.

Для удобной работы с Future в Dart доступны ключевые слова async и await:

- await — позволяет ожидать результата выполнения Future. Пока Event Loop не вернет результат Future, поток команд с await будет поставлен на паузу.
- async помечает метод как асинхронный, что позволяет внутри него использовать ключевое слово await.

Подробнее про механизмы квазипоточности и асинхронности можно изучить в официальной документации: [dart.dev/libraries/async/async-await](https://dart.dev/libraries/async/async-await).

## DartVM

Для запуска исходных кодов приложения на Dart поток команд сначала преобразуется в промежуточный язык (intermediate language), а затем в абстрактное синтаксическое дерево (abstract syntax tree, AST). В таком синтаксическом дереве вся программа представляется в виде гигантского графа, узлами которого являются примитивные операции. Затем этот граф сохраняется в виде двоичных файлов (сериализуется), такие файлы являются "слепками" и называются kernel binaries.

DartVM — это среда для выполнения kernel binaries. Она отвечает за интерпретацию и выполнение Dart-кода.

Это не полноценная виртуальная машина, а просто среда, которая изолирует приложение Dart от операционной системы, предоставляя всё необходимое для работы приложения Flutter: сборка мусора, управление объектами Dart и жизненным циклом приложения.

Также частью DartVM являются:

- Инструменты для отладки, профилирования и «горячей перезагрузки».
- Библиотеки для взаимодействия с операционной системой
- Интерпретатор языка Dart
- Инструменты компиляции Just-in-Time (JIT) и Ahead-of-Time (AOT)

DartVM является ключевым компонентом Dart.

## Взаимодействие DartVM со средой

DartVM взаимодействует с операционной системой для решения следующих задач:

- Управление памятью: вызывает системные функции ОС для выделения и освобождения памяти.
- Потоки и асинхронные операции: Использует системные механизмы для управления потоками ОС для реализации фоновых операций.
- Ввод/вывод:
  — События пользователя: жесты, клавиатура, мышь.
  — Чтение/запись файлов.
  — Взаимодействие по сети.
  — Использование устройств и датчиков.
- Управление процессом и жизненным циклом приложения.

DartVM управляет циклом событий приложения, позволяя приложениям асинхронно обрабатывать многочисленные операции ввода-вывода и пользовательские события без задержек. Сам по себе Dart является однопоточным, но DartVM создает несколько потоков операционной системы для своей работы, а также предоставляет возможность приложению Dart выгружать фоновые операции в отдельный поток операционной системы.

## Стандартные потоки Flutter

Движок Flutter с помощью механизмов DartVM запускает 4 параллельных потока команд для решения следующих задач:

* Взаимодействие с платформой (Platform Task Runner) — главный поток, управляет жизненным циклом приложения Flutter. Для любого приложения операционная система создает основной (главный, main) поток команд, который взаимодействует с операционной системой. Именно в этом потоке и живет движок Flutter, управляя жизненным циклом приложения.
* Обработка пользовательского интерфейса (UI Task Runner) — в этом потоке выполняется код корневого изолята — поведение приложения и компоновка. 
* Растеризация пользовательского интерфейса (Raster Task Runner) — взаимодействует с графическим ускорителем и формирует команды для отрисовки кадров пользовательского интерфейса.
* Ввод/вывод данных (IO Task Runner) — загружает и распаковывает изображения и файлы из ресурсов приложения, чтобы при отображении на экран изображения уже были загружены в оперативную памяти в таком виде, чтобы их было достаточно просто передать в модуль растеризации.

Данные потоки команд (исполнители, runner) могут выполняться как на отдельных потоках (thread) операционной системы, так и в рамках ранее созданных. Использование нескольких потоков дает возможность лучше задействовать несколько ядер центрального процессора и ускорить выполнение приложения Flutter.

## Flutter Embedder

Одним из ключевых элементов для работы с плагинами в экосистеме Flutter является Flutter Embedder. Эта нативная библиотека служит основой для запуска среды DartVM и взаимодействует с операционной системой, предоставляя возможность интеграции с нативными компонентами.

Основные механизмы Flutter Embedder:

- Инициализация: предоставляет функции для инициализации движка Flutter, включая загрузку необходимых ресурсов, таких как шрифты, изображения и другие статические данные приложения.
- Отрисовка: управляет циклом отрисовки пользовательского интерфейса.
- Обработка событий: позволяет обрабатывать нативные события и передавать их во Flutter.
- Управление памяти: предоставляет механизмы управления памятью, чтобы избежать утечек и других проблем с производительностью.
- Сетевые взаимодействия: используется для интеграции с нативными библиотеками, которые обеспечивают сетевое взаимодействие, а также для работы с базами данных и сторонними сервисами.

Использование Flutter Embedder позволяет разработчикам эффективно взаимодействовать с нативными кодом и операционной системой. Основным механизмом Flutter Embedder для взаимодействия с операционной системой являются каналы платформы (Platform Channels).

## Компиляция JIT и AOT

Приложение Flutter может компилироваться в двух режимах:

- Just-In-Time (JIT), когда код Dart преобразуется в промежуточный kernel binaries и в таком виде уже компилируется на устройстве во время работы приложения. Такой код может быть оптимизирован при последующем вызове. Также JIT поддерживает обновление кода в реальном времени (горячую перезагрузку), заметно ускоряя процесс разработки. Некоторые ОС могут запрещать режим JIT. С точки зрения производительности и скорости запуска JIT в среднем будет чуть медленнее, чем AOT. Хорошо подходит для разработки и отладки.

- Ahead-Of-Time (AOT) код приложения сразу компилируется под целевую платформу (в машинные команды центрального процессора целевой архитектуры) и объединяется с DartVM. Компилятор вырезается из DartVM, но все остальные функции остаются — управление памятью, взаимодействие с ОС, управление жизненным циклом и другое. Плохо подходит для разработки и отладки, но хорошо подходит для реальных пользователей. В среднем работает быстрее JIT.

## Сравнение JIT и AOT в Dart

В таблице представлено сравнение вариантов компиляции JIT и AOT.

|   |JIT|AOT|
|---|---|---|
|Скорость запуска приложения|Медленный (долгий «прогрев»)|Быстрый (мгновенный)|
|Производительность|Плавающая|Постоянная|
|Компиляция исходных кодов|Во время работы|До запуска|
|Отладка|Поддерживается|Не поддерживается|
|Горячее обновление (hot reload)|Есть|Нет|
|Примерное время сборки|1 секунда|3 секунды|
|Примерное время запуска|0,5 секунды|0,02 секунды|

Если говорить про производительность, то при выполнении JIT компиляция производит в реальном времени, что замедляет выполнение кода при первом исполнении. Однако при повторном исполнении того же кода, он может быть оптимизирован DartVM, что позволит получить более высокую пиковую производительность. Компиляция AOT выполняет оптимизацию заранее, поэтому код имеет одинаковую производительность при повторном исполнении.

Оценки по времени на сборку и запуск приведены примерные, чтобы показать порядок различий, а не конкретные значения.

## Сборка под разные таргеты

Приложения Flutter могут работать на всех популярных программно-аппаратных платформах:

- iOS, архитектура ARM64.
- Android, архитектуры ARM32 и ARM64.
- ОС Аврора, архитектуры ARM32 и ARM64.
- MacOS, архитектуры ARM64 и x86_64.
- Linux, архитектуры ARM32, ARM64 и x86_64.
- Windows, архитектуры x86_64.
- Веб-браузер, без привязки к архитектуре центрального процессора, так как код Dart компилируется в JavaScript.

В целом Flutter и Dart могут быть легко перенесены на новые платформы в будущем, например, на такие как Risc V.

## Упаковка приложения

Код приложения Flutter упаковывается вместе с ресурсами и библиотеками, которые будут частью обычного нативного нативного приложения. Код на Dart собирается в виде библиотек, которые линкуются с нативным приложением. Приложение может быть собрано и в варианте с JIT компиляцией для динамического исполнения, или же AOT — для большей производительности, что обеспечивает воспроизведение "слепков" на любых платформах.

Таким образом, на выходе разработчики могут получить традиционные установочные пакеты — RPM для ОС Аврора, APK для Android и IPA для iOS.

## История ОС Аврора

История ОС Аврора берет начало в нулевых годах. С 2007 года компания Nokia занималась развитием ОС. Помимо довольно популярной тогда ОС Symbian, Nokia также работала над Linux-системой для мобильных устройств, которая называлась Maemo. Примерно в то же время компания Intel развивала свою операционную систему Moblin.

В результате объединения проектов в 2010 году появился проект MeeGo — разработка операционной системы, которая могла бы охватить разные типы устройств, от персональных компьютеров до смартфонов. Параллельно с этим под управлением open-source сообщества развивался проект Mer. Он предоставлял основу для построения операционных систем, большой фреймворк включающий ряд библиотек, в том числе Qt.

В 2011 году мобильное подразделение Nokia перешло под управление Microsoft, однако некоторые сотрудники были заинтересованы в том, чтобы продолжить работу с Linux-системами и основали стартап Jolla в Финляндии. Сотрудники Jolla начали работу над своей операционной системой, вобравшей в себя многие наработки проектов Maemo и Meego. Новая система получила название Sailfish OS и была представлена в 2012 году.

В 2016 году в россии была основана компания "Открытая мобильная платформа" (ОМП), которая стала партнером Jolla по работе над Sailfish OS. Был сформирован отдельный продукт Sailfish Mobile OS RUS, нацеленный на корпоративный рынок и государственные компании России. А в 2019 году операционная система получила название ОС Аврора. Компания ОМП стала полноправным владельцем исходного кода операционной системы, а также обеспечила полный цикл разработки в РФ.

## Архитектура ОС Аврора

Архитектура операционной системы состоит из трех уровней.

На базовом уровне находятся ядро Linux, аппаратно зависимые компоненты и прошивка.
Уровень связующего ПО предназначен, как правило, для фреймворков.
В данном случае он включает в себя mer, который содержит цель для сборки кода и запуска ОС Аврора
и qml-приложений. Цель — это набор библиотек, заголовков для конкретной версии или архитектуры процессора.

Фреймворк Qt предоставляет основные библиотеки для разработки прикладного ПО.
Используется в качестве основного фреймворка разработки приложений в ОС Аврора и предоставляет API для частого
использования других функций устройства.

Верхний уровень предназначен для приложений и графического интерфейса.

Основной домашний экран и область пользовательского интерфейса приложения управляются подсистемой
Lipstick, которая обрабатывает:

*	домашний экран и панель запуска приложений;
*	навигацию с помощью жестов в основном системном интерфейсе;
*	композицию приложений;
*	окна и уведомления на системном уровне и на уровне пользовательского пространства;
*	блокировку устройства;
*	и изменение внешнего вида интерфейса

ОС Аврора включает в себя большое количество связующих библиотек и фреймворков, многие из которых
используются приложениями.
Основная часть библиотек и фреймворков написаны на языках C и C++.
Библиотеки, которые используются непосредственно в UI, включают в себя модули QML.
Это позволяет приложениям использовать их без дополнительных биндингов. 

Системные библиотеки включают в себя функции управления системой и устройством, в том числе:

*	обновление системы;
*	контроль устройств и обработка событий (например, событий, связанных с USB, зарядным
	устройством, разъемом для подключения наушников и тд);
*	управление режимом электропитания.

В ОС Аврора используется менеджер системы и сервисов systemd.
Данный подход сильно отличается от типичных скриптов инициализации SysV, но также является более
подходящим для мобильных систем в связи с запуском демонов по запросу.

Также используется дополнительный демон sensord, позволяющий записывать данные с датчиков
в циклические базы данных для последующей визуализации.

Компоненты, организующие интерфейс пользователя находятся в составе бибилиотеки Silica.

## Сравнение архитектуры Flutter и Qt

Flutter появился почти на 20 лет позже Qt, что по меркам IT очень много. При этом оба фреймворка очень похожи с точки зрения архитектуры:

- нативное приложение нужно лишь для запуска движка;
- код самого приложения работает в виртуальной среде;
- интерфейс отрисовывается с помощью кроссплатформенного высокопроизводительного движка;
- код самого приложения разрабатывается на JS-подобном языке (Dart и QML), однако для Qt можно писать его и на С++.

На диаграмме можно видеть много общего между Qt и Flutter. Ключевое сходство — пользовательский интерфейс отрисовывается внутри движка, а не через компонентную базу операционной системы. То есть интерфейс просто делается похожим под целевую платформу. Ключевое отличие — в Qt всегда используется только C++/QML, а во Flutter — Dart и язык нативной платформы.

## Сравнение Flutter и Qt

В таблице показаны ключевые сходства и различия между Flutter и Qt.

|   |Flutter|Qt|
|---|---|---|
|Поддерживаемые среды выполнения|iOS, Android, ОС Аврора, Linux, Windows, macOS, встраиваемые, веб-браузеры|iOS, Android, ОС Аврора, Linux, Windows, macOS, встраиваемые|
|Механизм отображения пользовательского интерфейса|Собственная быстрая отрисовка интерфейса|Собственная быстрая отрисовка интерфейса|
|Количество плагинов и сторонних компонентов|Много, количество быстро растет|Мало|
|Установка сторонних компонентов|Легко|Сложно|
|Простота разработки под несколько платформ|Легко|Сложно|
|Язык разработки кроссплатформенного кода|Dart|QML, C++|
|Язык разработки нативного кода|Зависит от целевой платформы — C/C++/Java/Objective C/Kotlin/Swift|С++|
