# Первое знакомство (быстрый старт)

Copyright © 2024–2025 ООО «Открытая мобильная платформа».
Этот документ предоставляется в соответствии
с [Публичной лицензией Creative Commons с указанием авторства версии 4.0 Международная](../../LICENSE.CC-BY-4.0.ru.md).

## Особенности Flutter SDK от ОМП

Проект "Flutter для ОС Аврора" реализует поддержку платформы ОС Аврора на фреймворке Flutter. Реализуя поддержку платформы ОС Аврора, фреймворк, для всех платформ, остается полнофункциональным, то есть его можно использовать и для разработки других платформ.

Исходные коды Flutter открыты, и Flutter SDK для ОС Аврора является полноценным форком (копией) от основного репозитория Google. Создать форк потребовалось, так как ОС Аврора не поддерживается официально корпорацией Google и не было возможности добавить поддержку в официальный репозиторий. В связи с этим, релизы Flutter SDK для ОС Аврора выходят с небольшими задержками.

Над развитием Flutter SDK для ОС Аврора работают не только сотрудники ОМП, но и представители российского сообщества, а также компании-партнеры.

ОС Аврора не поддерживается официально корпорацией Google, поэтому пакеты, взаимодействующие с операционной системой и нативными библиотеками, не будут работать в ОС Аврора из коробки, и к ним потребуется реализовать платформенный код своими силами. Как это сделать, будет рассказано в следующих лекциях.

Стоит отметить, что в качестве основной среды разработки для Аврора Flutter SDK потребуется использовать Visual Studio Code (или Codium). При этом VS Code обеспечивает полноценную разработку на Flutter для ОС Аврора.

## Установка и настройка Аврора SDK

Перед началом установки Аврора SDK требуется установить и настроить VirtualBox на компьютере, ведь с его помощью будут не только запускаться эмуляторы ОС Аврора, но и осуществляться сборка проектов.

Для установки Аврора SDK достаточно скачать установочные файлы к себе на компьютер и запустить мастер установки, следуя инструкции с официального сайта.

Адрес для скачивания Аврора SDK: [developer.auroraos.ru/downloads/sdk_mb2/](https://developer.auroraos.ru/downloads/sdk_mb2/)

Возможна установка в режиме Online (компоненты будут скачиваться при установке) или Offline ( сразу потребуется загрузить большой установочный файл).

С учетом того, что в будущем нам предстоит разрабатывать приложения на Flutter, то настоятельно рекомендуется использовать Ubuntu в качестве среды для запуска SDK.

Полная инструкция по установке доступна по адресу [developer.auroraos.ru/doc/5.1.3/sdk/app_development/setup/setup_linux](https://developer.auroraos.ru/doc/5.1.3/sdk/app_development/setup/setup_linux).

## Настройка Аврора SDK, шаги 1-3

1. В приветственном окне мастера установки нажать кнопку Далее.

2. В следующем окне выбрать каталог, в который будет установлена среда разработки, и нажать кнопку Далее.

3. В следующем окне выбрать технологию виртуализации: VirtualBox. В рамках данного курса мы будем использовать VirtualBox.

## Настройка Аврора SDK, шаги 4-6

4. В появившемся окне выбрать папку рабочего пространства, отличную от каталога для установки, для размещения проектов и нажать кнопку Далее. Выбранный каталог будет использоваться сборочным движком для сборки проектов.

5. В открывшемся окне выбрать необходимые для установки компоненты и нажать кнопку Далее. По умолчанию выбраны все компоненты. Рекомендуется ничего не отключать, если нет необходимости.

6. В окне о лицензионном соглашении следует установить переключатель в поле "Я согласен(а) с лицензией" и нажать кнопку Далее. При выборе пункта "Я не согласен(а) с лицензией" произойдет отмена всех пройденных ранее этапов и выход из мастера установки.

## Настройка Аврора SDK, шаги 7-9

7. В окне Всё готово к установке нажать кнопку Установить (Install).

8. В окне Установка Аврора SDK дождаться окончания процесса установки. Для просмотра подробностей о процессе установки необходимо нажать кнопку Показать детали. Установка может длиться долго. 

9. В окне Завершение установки Аврора SDK следует отметить пункт Запустить Аврора IDE для запуска Аврора SDK сразу после завершения процесса установки. Нажать кнопку Завершить.

## Установка Flutter SDK

После установки Аврора SDK вам потребуется установить Аврора Platform SDK и Flutter SDK для ОС Аврора. Скачиваем необходимые файлы и следуем инструкции в [официальном руководстве](https://developer.auroraos.ru/doc/extended/flutter/getting_started/install).

Все шаги будут раскрыты далее.

## Скачивание Аврора Platform SDK

Аврора Platform SDK (PSDK) — набор инструментов для разработки, отладки и тестирования компонентов ОС Аврора.

В состав Аврора PSDK входит:

* Chroot — образ корневой файловой системы (rootfs);
* Tooling — набор совместимых с хостом (chroot) инструментов сборки и служебных утилит;
* Target — образ ОС Аврора с зависимостями сборки под целевую архитектуру (цель сборки).

В настоящий момент доступны следующие таргеты:

* i486; x86_64 (начиная с версии 5.0): цель сборки — эмулятор из Application SDK;
* armv7hl: цель сборки — большинство устройств с ОС Аврора;
* aarch64: цель сборки — устройства на архитектуре armv8 (PinePhone, TrustPhone).

1. Сначала потребуется скачать и установить все файлы по инструкции: https://developer.auroraos.ru/doc/5.1.3/sdk/psdk/setup.

Путь для скачивания Platform SDK: [developer.auroraos.ru/downloads/p_sdk/](https://developer.auroraos.ru/downloads/p_sdk/)

Например, для версии 5.1.3.85 потребуется комплект файлов:

* Aurora_OS-5.1.3.85-MB2-Aurora_Platform_SDK_Chroot-x86_64.tar.bz2
* Aurora_OS-5.1.3.85-MB2-Aurora_SDK_Target-aarch64.tar.7z
* Aurora_OS-5.1.3.85-MB2-Aurora_SDK_Target-armv7hl.tar.7z
* Aurora_OS-5.1.3.85-MB2-Aurora_SDK_Target-x86_64.tar.7z
* Aurora_OS-5.1.3.85-MB2-Aurora_SDK_Tooling-x86_64.tar.7z

## Создание папки Аврора Platform SDK

2. Создать в домашней директории пользователя директорию **AuroraPlatformSDK**, в которой создать директории:

    **/sdks/aurora_psdk** — основная директория Platform SDK, куда будет установлен образ корневой файловой системы. Здесь важно наличие промежуточной директории sdks.

    **/tarballs** — директория, куда для удобства можно поместить установочные архивы.

    **/projects** — директория для сборки проектов.

```
mkdir -pv $HOME/AuroraPlatformSDK/tarballs
mkdir -pv $HOME/AuroraPlatformSDK/sdks/aurora_psdk
mkdir -pv $HOME/AuroraPlatformSDK/projects
```

## Распаковка Аврора Platform SDK

3. Скопировать установочные архивы в директорию tarballs:

```
cp -v $(pwd)/Aurora_OS-*.bz2 $HOME/AuroraPlatformSDK/tarballs
```

4. В директорию **$HOME/AuroraPlatformSDK/sdks/aurora_psdk** распаковать образ Platform SDK Chroot:

```
export PSDK_DIR=$HOME/AuroraPlatformSDK/sdks/aurora_psdk
export CHROOT_IMG=$(find $HOME/AuroraPlatformSDK/tarballs -iname "*chroot*")
sudo tar --numeric-owner -p -xjf $CHROOT_IMG --checkpoint=.1000 -C $PSDK_DIR
```

Последняя команда устанавливает Platform SDK Chroot, для успешной установки необходимо использовать пароль суперпользователя.

## Настройка Bash для удобства

5. Для удобства можно сохранить созданные ранее переменные в конфигурационный файл оболочки. Для оболочки Bash это файл $HOME/.bashrc.

```
if [[ -z $(grep PSDK_DIR ~/.bashrc) ]]; then
	echo 'export PSDK_DIR=$HOME/AuroraPlatformSDK/sdks/aurora_psdk' >> $HOME/.bashrc
fi
```

6. Создать псевдоним (alias) для запуска Platform SDK:

```
if [[ -z $(grep "alias aurora_psdk" ~/.bashrc) ]]; then
	echo 'alias aurora_psdk=$PSDK_DIR/sdk-chroot' >> ~/.bashrc
fi
```
После этого нужно применить изменения, открыв в терминале новую сессию:

```
$SHELL
```

7. Опционально можно также настроить скрипты автодополнения для использования внутри Platform SDK:

```
echo '[ -d /etc/bash_completion.d ] && for i in /etc/bash_completion.d/*;do . $i;done'  >> ~/.bashrc
```


## Запуск Platform SDK (PSDK)

1. Выполнить скрипт запуска Platform SDK:

```
$PSDK_DIR/sdk-chroot
```

или по псевдониму

```
aurora_psdk
```

При первом запуске будут выдаваться предупреждения, что будут созданы некоторые необходимые директории. Следует подтвердить действие клавишей Enter или C.

После запуска Platform SDK произойдет следующее:

* Выполнится временное изменение корневой директории (так называемый Chroot или Change root). Далее для краткости будем использовать термин Chroot, говоря об окружении с временно изменённой корневой директорией. Команда `ls -lah /` в Chroot покажет содержимое директории `$HOME/AuroraPlatformSDK/sdks/aurora_psdk`.
* Создадутся (при необходимости) директории для Platform SDK Tooling и Platform SDK Target, которые будут смонтированы, соответственно, как `/srv/mer/tooling` и `/srv/mer/targets` в Chroot.
* Корневой раздел системы `/` будет смонтирован в Chroot как `/parentroot`.
* Домашняя директория пользователя в Chroot будет смонтирована с тем же полным путем (доступна по значению переменной $HOME).
* Будут выполнены однократно конфигурационные скрипты.
* Изменится приглашение командной строки.

### Установка компонентов PSDK

1. Установить Platform SDK Tooling:

```
sdk-assistant tooling create Aurora_OS-5.1.3.85 tarballs/Aurora_OS-5.1.3.85-MB2-Aurora_SDK_Tooling-x86_64.tar.7z
```

2. Установить комплекты сборки под нужные архитектуры:

```
sdk-assistant target create Aurora_OS-5.1.3.85-x86_64 tarballs/Aurora_OS-5.1.3.85-MB2-Aurora_SDK_Target-x86_64.tar.7z

sdk-assistant target create Aurora_OS-5.1.3.85-armv7hl tarballs/Aurora_OS-5.1.3.85-MB2-Aurora_SDK_Target-armv7hl.tar.7z

sdk-assistant target create Aurora_OS-5.1.3.85-aarch64 tarballs/Aurora_OS-5.1.3.85-MB2-Aurora_SDK_Target-aarch64.tar.7z
```

## Проверка компонентов PSDK

Проверить список установленных целей сборки:

```
sdk-assistant list
```

Результатом выполнения команды должна быть иерархическая структура, корневым узлом которой является Platform SDK Tooling, далее идут комплекты сборки, для каждого из которых по умолчанию создается снепшот.

## Установка Flutter SDK

Для установки Flutter SDK требуется сначала установить зависимости:

```
sudo apt update && sudo apt install curl git git-lfs unzip bzip2 netcat-openbsd
```

Создать папку, где будет расположен Flutter SDK:

```
mkdir -p ~/.local/opt
```

И клонировать проект Flutter SDK в созданную папку:

```
git clone --branch 3.27.1 https://gitlab.com/omprussia/flutter/flutter.git   ~/.local/opt/flutter-3.27.1
```

Стоит учесть, что 3.27.1 — это версия, которая была крайней на момент подготовки курса. Ее следует заменить на самую последнюю версию со страницы [gitlab.com/omprussia/flutter/flutter/-/tags](https://gitlab.com/omprussia/flutter/flutter/-/tags).

## Настройка Bash для Flutter SDK

Для удобства вызова командной строки Flutter добавляем alias в ~/.bashrc:

```
echo "alias flutter-aurora=$HOME/.local/opt/flutter-3.27.1/bin/flutter" >> ~/.bashrc
```

Для удобства вызова командной строки Dart добавляем alias в ~/.bashrc:

```
echo "alias dart-aurora=$HOME/.local/opt/flutter-3.27.1/bin/dart" >> ~/.bashrc
```

Применяем изменения ~/.bashrc:

```
source ~/.bashrc
```

## Настройка среды Flutter SDK

Конфигурация Flutter перед работой:

```
flutter-aurora config --aurora-psdk-dir ~/AuroraPlatformSDK/sdks/aurora_psdk
```

Во Flutter CLI доступна команда doctor, которая позволяет проверить, все ли необходимые для сборки компоненты установлены верно, и при необходимости скачает недостающие:

```
flutter-aurora doctor
```

Так как версия Flutter SDK от ОМП не является официльной, то doctor покажет предупреждения, которые можно игнорировать. Также могут отображаться ошибки того, что не установлены утилиты для разработки под Android, Chrome и Linux. Их также можно игнорировать, если вы планируете только разработку под ОС Аврора на данном компьютере.

## Как создать проект

После установки и настройки Аврора SDK, Аврора Platform SDK и Flutter SDK для ОС Аврора вы можете собрать и запустить свой первый проект на эмуляторе ОС Аврора. Для нашего первого примера лучше воспользоваться консолью — открыть терминал, перейти в папку с проектами и создать пустой проект Flutter, указав в качестве платформы aurora: `flutter-aurora create --platforms=aurora --template=app --org=ru.aurora app_demo`

Будет создана папка проекта со всеми необходимы файлами как для приложения на Flutter, так и нативного приложения для ОС Аврора, которое и будет запускать кроссплатформенный код.

Затем потребуется скачать все внешние зависимости — инструменты и пакеты с помощью команды `flutter-aurora pub get`.

Получив все необходимое вы сможете собрать приложение в установочный RPM-пакет для ОС Аврора с помощью команды `flutter-aurora build aurora --release`.

Если у вас уже есть существующее приложение на Flutter, то вы сможете легко добавить к нему поддержку ОС Аврора. Об это будет рассказано в лекции ["Особенности разработки для ОС Аврора"](../specifics/lecture.md#как-портировать-существующее-приложение-на-ос-аврора)

## Как открыть и запустить проект

Теперь вы можете запустить эмулятор ОС Аврора через VirtualBox и включить у него в настройках режим разработчика. Это позволит запустить приложение на виртуальной машине, эмулирующей ОС Аврора, выполнив в консоли команду `flutter-aurora run -d aurora`.

После сборки и установки приложение автоматически запустится на эмуляторе.

## Структура исходных кодов

Каждый проект на Flutter содержит следующие ключевые файлы и папки:

- папки /android, /ios, /aurora — платформенный код, включающий как нативное приложение, так и нативную реализацию плагинов, если это необходимо;
- папка /build — результат сборки приложения, среди которых будут готовые ресурсы приложения, двоичные файлы и библиотеки;
- папка /lib — код Dart в папке, основная работа будет идти с файлами в этой папке;
- папка /test — автоматические тесты на Dart;
- файл pubspec.yaml — параметры проекта и внешние плагины Dart проекта;
- файл analysis_options.yaml — дополнительные параметры линтера.

## Настройки под платформу

Помимо программного кода нативное приложение должно содержать параметры для отображения приложения пользователю и упаковки установочного пакета. В каждом проекте для ОС Аврора есть следующие подпапки в папке aurora:

- /desktop — содержит файл desktop с названием приложения и параметрами, включая необходимые разрешения (permissions)
- /icons — иконки приложения
- /rpm — spec-файл для сборки установочного пакета для ОС Аврора

## Структура установочного пакета

Содержимое установочного RPM-пакета для приложения на Flutter мало чем отличается от нативного приложения — содержит нативный исполняемый файл, зависимые библиотеки и ресурсы. Типовая структура папок Flutter-приложения:

- /usr/bin — бинарный файл нативного приложения
- /usr/share/applications — desktop-файл для запуска приложения
- /usr/share/icons — иконки приложения
- /usr/share/APP_NAME/lib — нативные библиотеки Flutter, слинкованные с нативным приложением
- /usr/share/APP_NAME/flutter_assets — ресурсы, которые используются внутри DartVM

## Как подключить реальный смартфон

Для того, чтобы можно было устанавливать приложения на реальный смартфон, требуется настроить соединение с ним по инструкции: [developer.auroraos.ru/doc/5.1.3/sdk/app_development/work/launch/device](https://developer.auroraos.ru/doc/5.1.3/sdk/app_development/work/launch/device).

Для подключения мобильного устройства (МУ) к среде разработки необходимо подключить его к персональному компьютеру разработчика по USB-проводу. Альтернативно можно подключить МУ к той же сети WiFi, что и компьютер.

Перед добавлением МУ необходимо настроить подключение по SSH. Для этого на МУ необходимо выполнить следующие действия:
* Перейти в Настройки → Средства разработчика → пункт Удалённое соединение;
* Задать SSH-пароль и нажать кнопку Сохранить.

В том же разделе отключить «Включить валидацию пакетов».

## Добавления устройства в Аврора IDE

Чтобы подключить МУ к Аврора IDE, необходимо выполнить следующие действия:

* В IDE открыть вкладку Инструменты → Параметры → Устройства.
* Нажать кнопку **Добавить устройство**.
* Выбрать пункт **Устройство ОС Аврора** и нажать кнопку **Запустить мастера**.

## Настройка соединения по SSH

Ввести имя пользователя и IP-адрес МУ (по умолчанию IP-адрес SSH-соединения и пользователь defaultuser).

## Создание ключей шифрования

Создать пару ключей или выбрать существующие.

## Установка ключи шифрования

Нажать кнопку **Установить ключ**, после в диалоговом окне ввести имя пользователя и пароль (по умолчанию это пользователь defaultuser).

Если пароль введён верно, ключ будет успешно установлен.

После успешной установки ключа рядом с кнопкой должна появиться зелёная галочка.

## Завершение подключения устройства

Нажать кнопку **Далее**, после чего МУ будет подготовлено к соединению. 

Когда подготовка завершится, снова нужно нажать кнопку **Далее**.

При необходимости на вкладке **Конфигурация** ввести название новой конфигурации и диапазон свободных портов, а затем нажать кнопку **Далее**. По умолчанию в названии конфигурации будет записана модель МУ и тип архитектуры. Количество свободных портов должно быть не менее двух, это необходимо для отладки.

## Подключаем устройство к Flutter CLI

Для добавления и настройки физических устройств на ОС Аврора, а также для последующего запуска и отладки приложений, Flutter CLI поддерживает команду aurora-devices, которая работает по аналогии с командой custom-devices.

Доступные команды aurora-devices:

* add — добавление нового устройства.
* delete — удаление устройства по id.
* list — вывод списка добавленных устройств.
* reset — сброс файла конфигурации устройств.

Настройка нового устройства:

* (Не обязательно, но рекомендуется) Подключить устройство на ОС Аврора к компьютеру с помощью кабеля.
* Выполнить команду add и в интерактивном режиме заполнить запрашиваемые данные устройства.

В результате выполнения шагов в файл конфигурации устройств добавится новое устройство, готовое для работы: ~/.config/flutter/aurora_devices.json.

## Запускаем на устройстве

Перед запуском на устройстве вы можете проверить, что добавление прошло успешно — команда `flutter-aurora devices list` должна отобразить ваше устройство.

Если устройство отобразится в списке, значит оно может использоваться для запуска и отладки вашего приложения. 

Запуск на реальном устройстве осуществляется также командой `flutter-aurora run`.
