#include <QDebug>
#include <QString>

#include "urihandler.h"
#include "urihandleradaptor.h"

static const auto PATH = QStringLiteral("/");
static const auto SERVICE = QStringLiteral(SERVICE_NAME);

UriHandler::UriHandler(QObject *parent)
    : QObject(parent)
    , m_dbusRegistered(false)
{
    new UriHandlerAdaptor(this);

    QDBusConnection connection = QDBusConnection::sessionBus();
    if (!connection.registerService(SERVICE)) {
        qCritical() << "Unable to register DBus service" << SERVICE;
        return;
    }

    if (!connection.registerObject(PATH, this)) {
        qCritical() << "Unable to register DBus object" << SERVICE;
        return;
    }

    m_dbusRegistered = true;
}

UriHandler::~UriHandler()
{
    if (m_dbusRegistered) {
        QDBusConnection connection = QDBusConnection::sessionBus();
        connection.unregisterObject(PATH);
        connection.unregisterService(SERVICE);
    }
}

void UriHandler::openUri(const QStringList &args)
{
    if (!args.isEmpty())
        emit openedUri(args.first());
}
