#pragma once

#include <QAudioInput>
#include <QIODevice>
#include <QByteArray>

class CaptureLevel : public QObject
{
    Q_OBJECT

public:
    CaptureLevel(const QAudioFormat &format);
    void start(QIODevice *device);

    float level() const;

signals:
    void levelChanged(float level);

private slots:
    void onReadyRead();
    void stop();

private:
    QIODevice *m_device;
    float m_level;
    int m_maxRms;
};

class AudioInput : public QObject
{
    Q_OBJECT

public:
    AudioInput();
    ~AudioInput() = default;

    void start();
    void stop();
    float rms() const;

signals:
    void rmsChanged(float rms);

private:
    void initializeAudio(const QAudioDeviceInfo &deviceInfo);

private:
    QScopedPointer<CaptureLevel> m_capture;
    QScopedPointer<QAudioInput> m_audioInput;
};
