#pragma once

#include <QObject>
#include <QQuickItem>
#include <QVariantMap>

#include <audiocontext.h>
#include <callmanager.h>

using ru::auroraos::call::AudioContext;
using ru::auroraos::call::Call;
using ru::auroraos::call::CallManager;

class AudioCall;

class AudioCallManager : public CallManager
{
    Q_OBJECT

    Q_PROPERTY(bool holdable READ holdable WRITE setHoldable NOTIFY holdableChanged)
    Q_PROPERTY(bool redialable READ redialable WRITE setRedialable NOTIFY redialableChanged)

public:
    explicit AudioCallManager(const QString &accountId, QObject *parent = nullptr);
    ~AudioCallManager() = default;

    Q_INVOKABLE AudioCall *getAudioCall(const QString &callId) const;
    Q_INVOKABLE Call *initiateCall(const QVariantMap &properties);
    Q_INVOKABLE Call *reportIncomingCall(const QVariantMap &properties);

    bool holdable() const;
    void setHoldable(bool on);

    bool redialable() const;
    void setRedialable(bool on);

public slots:
    void openUri(const QString &uri);

signals:
    void holdableChanged(bool on);
    void redialableChanged(bool on);

private:
    Call *newCall(QVariantMap &properties);

private:
    AudioContext m_audioContext;
    unsigned int m_callId;
    bool m_holdable;
    bool m_redialable;
};

QML_DECLARE_TYPE(AudioCallManager)
