#pragma once

#include <QObject>
#include <QQuickItem>
#include <QVariantMap>
#include <QTimer>

#include <audiocontext.h>
#include <call.h>

#include "audioinput.h"
#include "audiooutput.h"

using ru::auroraos::call::AudioContext;
using ru::auroraos::call::Call;

class AudioCall : public Call
{
    Q_OBJECT
    Q_PROPERTY(float microphoneRms READ microphoneRms NOTIFY microphoneRmsChanged)

public:
    AudioCall(
        ru::auroraos::call::CallManager *manager,
        const QString &id,
        const QVariantMap &parameters,
        QObject *parent);

    ~AudioCall();
    
    Q_INVOKABLE void accept();
    Q_INVOKABLE void disconnect();

    float microphoneRms() const;

signals:
    void microphoneRmsChanged(float rms);

private:
    void startAudio();
    void stopAudio();

private slots:
    void onCallStatusChanged(Call::Status);

private:
    QTimer m_answerTimer;
    AudioInput m_input;
    AudioOutput m_output;
};

QML_DECLARE_TYPE(AudioCall)
