/*******************************************************************************
**
** Copyright (C) 2022 ru.auroraos
**
** This file is part of the Моё приложение для ОС Аврора project.
**
** Redistribution and use in source and binary forms,
** with or without modification, are permitted provided
** that the following conditions are met:
**
** * Redistributions of source code must retain the above copyright notice,
**   this list of conditions and the following disclaimer.
** * Redistributions in binary form must reproduce the above copyright notice,
**   this list of conditions and the following disclaimer
**   in the documentation and/or other materials provided with the distribution.
** * Neither the name of the copyright holder nor the names of its contributors
**   may be used to endorse or promote products derived from this software
**   without specific prior written permission.
**
** THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
** AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
** THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
** FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
** IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
** OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
** PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
** LOSS OF USE, DATA, OR PROFITS;
** OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
** WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
** (INCLUDING NEGLIGENCE OR OTHERWISE)
** ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
** EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
**
*******************************************************************************/

import QtQuick 2.0
import Sailfish.Silica 1.0
import AudioCallExample 1.0
import QtMultimedia 5.6
import Nemo.Policy 1.0

Page {
    objectName: "mainPage"
    allowedOrientations: Orientation.All

    property int callId: 0
    property bool soundActive

    function nextCallee() {
        var id = callId;
        callId++;
        return id;
    }

    Column {
        anchors.fill: parent

        PageHeader {
            title: qsTr("AudioCall")
            extraContent.children: [
                IconButton {
                    icon.source: "image://theme/icon-m-about"
                    anchors.verticalCenter: parent.verticalCenter

                    onClicked: pageStack.push(Qt.resolvedUrl("AboutPage.qml"))
                }
            ]
        }

        Label {
            text: callManager.error
        }

        Label {
            text: "Calls: " + callManager.calls.length
        }

        TextSwitch {
            id: holdableSwitch

            text: "Make holdable calls"
            automaticCheck: false
            checked: callManager.holdable

            onClicked: callManager.holdable = !checked
        }

        TextSwitch {
            id: redialableSwitch
            text: "Can redial"
            automaticCheck: false
            checked: callManager.redialable

            onClicked: callManager.redialable = !checked
        }

        TextField {
            id: delayValue
            label: "Delay before incoming call, ms"
            validator: IntValidator{ bottom: 0; top: 10000; }
            text: "0"
        }

        Button {
            text: "Create incoming call"
            onClicked: incomingCallTimer.restart()
        }

        Timer {
            id: incomingCallTimer
            interval: parseInt(delayValue.text)
            running: false
            repeat: false
            onTriggered: {
                var callee = nextCallee();
                var call = callManager.reportIncomingCall({
                    "remoteHandle" : "_" + callee,
                    "remoteId"     : "Incoming call " + callee
                });
            }
        }

        Button {
            id: outgoungButton
            text: "Create outgoing call"
            onClicked: {
                var callee = nextCallee();
                var call = callManager.initiateCall({
                    "remoteHandle" : "_" + callee,
                    "remoteId"     : "Outgoing call " + callee
                });
            }
        }

        SilicaListView {
            anchors.top: outgoungButton.bottom
            anchors.bottom: parent.bottom
            model: callManager.calls
            delegate: Item {
                height: callControl.height
                property var call: callManager.getCall(modelData)

                Column {
                    id: callControl
                    Label {
                        text: call.remoteId + " - " + call.localId
                    }

                    Label {
                        text: "Status: " + call.status
                    }

                    Row {
                        Button {
                            text: "Accept"
                            visible: call.status == Call.Ringing
                            onClicked: call.accept()
                        }

                        Button {
                            text: "Disconnect"
                            onClicked: call.disconnect()
                        }

                        Rectangle {
                            anchors.bottom: parent.bottom
                            width: 20
                            color: "green"
                            height: parent.height * call.microphoneRms
                        }
                    }
                }
            }
        }
    }
}
