#pragma once

#include <QObject>
#include <QVariantList>

#include <audiocontrolinterface.h>

class AudioManager : public QObject, public ru::auroraos::call::AudioControlInterface
{
    Q_OBJECT
    Q_INTERFACES(ru::auroraos::call::AudioControlInterface)
    Q_PROPERTY(bool mute READ mute WRITE setMute NOTIFY muteChanged)
    Q_PROPERTY(QVariantList devices READ devices NOTIFY devicesChanged);
    Q_PROPERTY(int outputDeviceIndex READ outputDeviceIndex WRITE setOutputDeviceIndex NOTIFY outputDeviceIndexChanged);

public:
    explicit AudioManager(QObject *parent = nullptr);
    ~AudioManager() = default;

    QVariantList devices() const;

    bool mute() const;
    void setMute(bool on);

    int outputDeviceIndex() const;
    void setOutputDeviceIndex(int index);

signals:
    void muteChanged(bool mute);
    void devicesChanged(const QList<ru::auroraos::call::AudioDevice> &devices);
    void outputDeviceIndexChanged(int index);

private:
    bool m_mute;
    QList<ru::auroraos::call::AudioDevice> m_audioDevices;
    QString m_inputDeviceId;
    QString m_outputDeviceId;
    int m_outputDeviceIndex;

    // AudioControlInterface
signals:
    void RequestMute(bool mute) override;
    void RequestAudioRoute(
            const QString &inputDeviceId,
            const QString &outputDeviceId) override;

public slots:
    void UpdateAudioRouteState(
            const QList<ru::auroraos::call::AudioDevice> &devices,
            bool microphoneMuted,
            const QString &activeInputDeviceId,
            const QString &activeOutputDeviceId) override;
    void UpdateAudioRoute(
            bool microphoneMuted,
            const QString &activeInputDeviceId,
            const QString &activeOutputDeviceId) override;
};
