
#include "audiomanager.h"
#include <QDebug>

using ru::auroraos::call::AudioDevice;

AudioManager::AudioManager(QObject *parent)
    : QObject(parent)
    , m_mute(false)
    , m_outputDeviceIndex(-1)
{
}

bool AudioManager::mute() const
{
    return m_mute;
}

void AudioManager::setMute(bool on)
{
    emit RequestMute(on);
}

QVariantList AudioManager::devices() const
{
    QVariantList result;
    for (const auto &device : m_audioDevices)
        result.append(QVariant::fromValue(device));

    return result;
}

int AudioManager::outputDeviceIndex() const
{
    return m_outputDeviceIndex;
}

void AudioManager::setOutputDeviceIndex(int index)
{
    if (index >= 0 && index < m_audioDevices.size()) {
        // An empty device id means no change.
        emit RequestAudioRoute(QStringLiteral(""), m_audioDevices.at(index).id);
    }
}

void AudioManager::UpdateAudioRouteState(
    const QList<AudioDevice> &devices,
    bool microphoneMuted,
    const QString &activeInputDeviceId,
    const QString &activeOutputDeviceId)
{
    // Filter out input-only devices.
    QList<AudioDevice> availableDevices;
    for (const auto &device : devices) {
        if (device.hasOutput)
            availableDevices.append(device);
    }

    // Deselect the current device as we recreate the device list
    // and the previous index is already invalid.
    if (m_outputDeviceIndex >= 0) {
        m_outputDeviceIndex = -1;
        emit outputDeviceIndexChanged(m_outputDeviceIndex);
    }

    m_audioDevices = availableDevices;
    emit devicesChanged(m_audioDevices);

    UpdateAudioRoute(microphoneMuted, activeInputDeviceId, activeOutputDeviceId);
}

void AudioManager::UpdateAudioRoute(
        bool muteMicrophone,
        const QString &inputDeviceId,
        const QString &outputDeviceId)
{
    if (m_mute != muteMicrophone) {
        m_mute = muteMicrophone;
        emit muteChanged(m_mute);
    }

    m_inputDeviceId = inputDeviceId;

    m_outputDeviceIndex = -1;
    m_outputDeviceId = QString();
    if (m_outputDeviceId != outputDeviceId) {
        for (int i = 0; i < m_audioDevices.size(); i++) {
            if (m_audioDevices.at(i).id == outputDeviceId) {
                m_outputDeviceIndex = i;
                m_outputDeviceId = outputDeviceId;
                break;
            }
        }
    }
    emit outputDeviceIndexChanged(m_outputDeviceIndex);
}
