################################################################################
##
## Copyright (C) 2022 ru.auroraos
##
## This file is part of the Моё приложение для ОС Аврора project.
##
## Redistribution and use in source and binary forms,
## with or without modification, are permitted provided
## that the following conditions are met:
##
## * Redistributions of source code must retain the above copyright notice,
##   this list of conditions and the following disclaimer.
## * Redistributions in binary form must reproduce the above copyright notice,
##   this list of conditions and the following disclaimer
##   in the documentation and/or other materials provided with the distribution.
## * Neither the name of the copyright holder nor the names of its contributors
##   may be used to endorse or promote products derived from this software
##   without specific prior written permission.
##
## THIS SOFTWARE IS PROVIDED BY THE COPYRIGHT HOLDERS AND CONTRIBUTORS "AS IS"
## AND ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO,
## THE IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS
## FOR A PARTICULAR PURPOSE ARE DISCLAIMED.
## IN NO EVENT SHALL THE COPYRIGHT HOLDER OR CONTRIBUTORS BE LIABLE
## FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY,
## OR CONSEQUENTIAL DAMAGES (INCLUDING, BUT NOT LIMITED TO,
## PROCUREMENT OF SUBSTITUTE GOODS OR SERVICES;
## LOSS OF USE, DATA, OR PROFITS;
## OR BUSINESS INTERRUPTION)
## HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY,
## WHETHER IN CONTRACT, STRICT LIABILITY, OR TORT
## (INCLUDING NEGLIGENCE OR OTHERWISE)
## ARISING IN ANY WAY OUT OF THE USE OF THIS SOFTWARE,
## EVEN IF ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
##
################################################################################

TARGET = ru.auroraos.AudioCallExample

QT += quick multimedia dbus

CONFIG += \
    auroraapp

system(qdbusxml2cpp dbus/$${TARGET}.xml -a src/urihandleradaptor -c UriHandlerAdaptor)

PKGCONFIG += callservice mlite5

DEFINES += \
    AUDIO_GENERATOR_CONFIG_PATH=\\\"\/apps/$${TARGET}/enableAudioOutputGenerator\\\" \
    USE_CALL_ICON_CONFIG_PATH=\\\"\/apps/$${TARGET}/useCallIcon\\\" \

SOURCES += \
    src/audiocallmanager.cpp \
    src/audiocall.cpp \
    src/audioinput.cpp \
    src/audiomanager.cpp \
    src/audiooutput.cpp \
    src/urihandler.cpp \
    src/urihandleradaptor.cpp \
    src/main.cpp

HEADERS += \
    src/audiocallmanager.h \
    src/audiocall.h \
    src/audioinput.h \
    src/audiomanager.h \
    src/audiooutput.h \
    src/urihandler.h \
    src/urihandleradaptor.h

DISTFILES += \
    rpm/ru.auroraos.AudioCallExample.spec \
    ru.auroraos.AudioCallExample.desktop \
    AUTHORS.md \
    CODE_OF_CONDUCT.md \
    CONTRIBUTING.md \
    LICENSE.BSD-3-CLAUSE.md \
    README.md \
    qml/AudioCallExample.qml \
    qml/cover/DefaultCoverPage.qml \
    qml/pages/AboutPage.qml \
    qml/pages/MainPage.qml \

svgs.path = /usr/share/${TARGET}/svgs
svgs.files = svgs/*.svg

INSTALLS += svgs

appicon.sizes = \
    86 \
    108 \
    128 \
    172 \
    256

for(iconsize, appicon.sizes) {
    profile = $${iconsize}x$${iconsize}
    targetPath = $${OUT_PWD}/icons/$${profile}
    system(mkdir -p $${targetPath})

    appicon.commands += /usr/bin/sailfish_svg2png \
        -s 1 1 1 1 1 1 $${iconsize} \
        $${_PRO_FILE_PWD_}/appicon \
        $${targetPath}/apps &&

    appicon.files += $${targetPath}
}

appicon.commands += true
appicon.path = /usr/share/icons/hicolor/

INSTALLS += appicon

CONFIG += auroraapp_i18n

TRANSLATIONS += \
    translations/ru.auroraos.AudioCallExample.ts \
    translations/ru.auroraos.AudioCallExample-ru.ts \
