#pragma once

#include <QAudioOutput>
#include <QIODevice>
#include <QByteArray>

class Generator : public QIODevice
{
    Q_OBJECT

public:
    Generator(const QAudioFormat &format, qint64 durationUs, int sampleRate);

    void start();
    void stop();

    qint64 readData(char *data, qint64 maxlen) override;
    qint64 writeData(const char *data, qint64 len) override;
    qint64 bytesAvailable() const override;

private:
    void generateData(const QAudioFormat &format, qint64 durationUs, int sampleRate);

private:
    qint64 m_pos = 0;
    QByteArray m_buffer;
};

class AudioOutput : public QObject
{
    Q_OBJECT

public:
    AudioOutput();
    ~AudioOutput() = default;

    void start();
    void stop();

private:
    void initializeAudio(const QAudioDeviceInfo &deviceInfo);

private:
    QScopedPointer<Generator> m_generator;
    QScopedPointer<QAudioOutput> m_audioOutput;

    float m_toneFreqHz;
};
