import {
  ZOOM_MAX,
  ZOOM_MIN,
  ZOOM_SENSITIVITY,
  ZOOM_STEP,
} from '../kanbans/Const';
import { EndlessCanvas } from './EndlessCanvas';
import { usePhaserStore } from '../../stores/phaserStore';
const store = usePhaserStore();

export function updateZoom(scene: EndlessCanvas, change: number) {
  let newZoom = scene.cameras.main.zoom + change;
  newZoom = Phaser.Math.Clamp(newZoom, ZOOM_MIN, ZOOM_MAX);
  scene.cameras.main.zoom = newZoom;
  updateZoomPercentage(scene);
}

export function updateZoomPercentage(scene: EndlessCanvas) {
  const text = `${(scene.cameras.main.zoom * 100).toFixed(0)}%`;
  store.setZoomPercentage(text);
}
export default (scene: EndlessCanvas) => {
  scene.input.on('wheel', (pointer, gameObjects, deltaX, deltaY) => {
    //@ts-ignore
    if (scene.keys.ctrl.isDown) {
      updateZoom(scene, deltaY * ZOOM_SENSITIVITY);
    }
  });
};
