import { describe, it, expect, jest, beforeEach } from '@jest/globals';
import { createRouter, createWebHistory } from 'vue-router';
import { mount } from '@vue/test-utils';
import { Quasar, QLayout, QPageContainer, QPage } from 'quasar';
import routes from '../../../src/router/routes';
import RegistrationPage from '../../../src/pages/RegistrationPage.vue';
import { createPinia, defineStore } from 'pinia';
import RegForm from '../../../src/components/RegForm.vue';
// Mocks for any plugins or modules
jest.mock('src/boot/apollo', () => ({
  apollo: {
    default: {
      query: jest.fn(() => Promise.resolve({ data: {} })), // Возвращаем промис с пустыми данными
      mutate: jest.fn(() => Promise.resolve({ data: {} })),
    },
    registrado: {
      query: jest.fn(() => Promise.resolve({ data: {} })),
      mutate: jest.fn(() => Promise.resolve({ data: {} })),
    },
  },
}));

// Create instances of router and pinia
const router = createRouter({
  history: createWebHistory(process.env.BASE_URL),
  routes,
});

const pinia = createPinia();

// The describe block contains your test suite
describe('RegistrationPage', () => {
  let wrapper;

  // This runs before each test case
  beforeEach(() => {
    wrapper = mount(
      {
        template: `
       <q-layout>
          <q-page-container>
            <q-page>
              <registration-page />
            </q-page>
          </q-page-container>
        </q-layout>
    `,
        components: { RegistrationPage },
      },
      {
        global: {
          plugins: [Quasar, router, pinia],
        },
      },
    );
  });

  it('Проверка Наличие верхнего тулбарчика', () => {
    console.log(wrapper.html());
    const Title = wrapper.findComponent(QPageContainer);
    expect(Title.exists()).toBeTruthy();
    expect(Title.text()).toContain('Регистрация в Universo');
  });
  it('Проверка центральной надписи', () => {
    const page = wrapper.findComponent(QPage);
    expect(page.exists()).toBeTruthy();
    expect(page.text()).toContain(
      'На следующих шагах вы можете зарегистрироваться на портале',
    );
  });
  it('increments "step" by 1 when the "Accept" button is clicked', async () => {
    // Проверяем, что начальное значение step равно 1
    expect(wrapper.vm.step).toBe(1);

    // Находим кнопку "Принимаю". Предполагается, что в вашем компоненте есть только одна такая кнопка.
    // Если кнопка имеет уникальный класс, идентификатор или другой атрибут, используйте его для поиска.
    const button = wrapper.find('button:contains("Принимаю")'); // Замените селектор на корректный

    // Симулируем клик на кнопке
    await button.trigger('click');

    // Дожидаемся асинхронного обновления данных компонента
    await wrapper.vm.$nextTick();

    // Проверяем, что значение step увеличилось
    expect(wrapper.vm.step).toBe(2);
  });
  it('Проверка центральной надписи', async () => {
    console.log(wrapper.html());
    const button = wrapper.findComponent({ name: 'QBtn' }); // Или любой другой уникальный идентификатор
    expect(button.exists()).toBe(true); // Убедитесь, что кнопка найдена
    // Убедитесь, что кнопка найдена
    await button.trigger('click');
  });
});
