import RegForm from '../../../src/components/RegForm.vue';
import { describe, it, expect, jest, beforeEach } from '@jest/globals';
import { createRouter, createWebHistory } from 'vue-router';
import { mount } from '@vue/test-utils';
import { Quasar, QLayout, QPageContainer, QPage } from 'quasar';
import routes from '../../../src/router/routes';
import { createPinia, defineStore } from 'pinia';

jest.mock('src/boot/apollo', () => ({
  apollo: {
    default: {
      query: jest.fn(() => Promise.resolve({ data: {} })), // Возвращаем промис с пустыми данными
      mutate: jest.fn(() => Promise.resolve({ data: {} })),
    },
  },
}));

const router = createRouter({
  history: createWebHistory(process.env.BASE_URL),
  routes,
});

const pinia = createPinia();

describe('RegForm', () => {
  let wrapper;
  beforeEach(() => {
    wrapper = mount(RegForm, {
      global: {
        plugins: [Quasar, router, pinia],
      },
    });
  });

  it('renders input fields for name, last name, username, and passwords', async () => {
    expect(wrapper.find('#first_name').exists()).toBe(true);
    expect(wrapper.find('#last_name').exists()).toBe(true);
    expect(wrapper.find('#username').exists()).toBe(true);
    expect(wrapper.find('input[type="password"]').exists()).toBe(true); // Adjust if you have specific selectors for password fields
    // Add more assertions as needed
  });

  it('renders selects for gender and language', () => {
    const wrapper = mount(RegForm);
    expect(wrapper.findAll('select').length).toBe(2); // Пол и язык
  });

  // Проверка наличия кнопки регистрации

  it('renders a submit button', () => {
    const wrapper = mount(RegForm);
    expect(wrapper.find('button[type="submit"]').exists()).toBeTruthy();
  });

  // Проверка наличия контейнера капчи

  it('renders a captcha container', () => {
    const wrapper = mount(RegForm);
    expect(wrapper.find('#captcha-container').exists()).toBeTruthy();
  });
});
