import { describe, it, expect, jest, beforeEach } from '@jest/globals';
import { createRouter, createWebHistory } from 'vue-router';
import { mount } from '@vue/test-utils';
import { Quasar, QLayout, QPageContainer, QPage } from 'quasar';
import { createPinia } from 'pinia';
import routes from '../../../src/router/routes';
import MainLayout from '../../../src/layouts/MainLayout.vue';

jest.mock('src/boot/apollo', () => ({
  // Мокирование экспортов из apollo.ts
}));

const router = createRouter({
  history: createWebHistory(process.env.BASE_URL),
  routes,
});

const pinia = createPinia();

describe('MainLayout.vue', () => {
  let wrapper;

  beforeEach(async () => {
    wrapper = mount(MainLayout, {
      global: {
        plugins: [Quasar, router, pinia],
        mocks: {
          $q: {
            platform: {
              has: {},
            },
            lang: {
              rtl: false,
            },
            screen: {
              lt: { sm: false },
              gt: { xs: true },
            },
          },
        },
      },
    });
  });

  it('Проверяем, содержит  компонент текст "Universo" ', async () => {
    expect(wrapper.text()).toContain('Universo');
  });
  it('Проверяем наличие входа', async () => {
    expect(wrapper.text()).toContain('Вход');
  });
});
