import { describe, it, expect, jest, beforeEach } from '@jest/globals';
import { createRouter, createWebHistory } from 'vue-router';
import { mount, flushPromises } from '@vue/test-utils';
import { Quasar, QLayout, QPageContainer, QPage } from 'quasar';
import { createPinia } from 'pinia';
import routes from '../../../src/router/routes'; // Импорт маршрутов из вашего файла маршрутов
import LoginPage from '../../../src/pages/LoginPage.vue';

jest.mock('src/boot/apollo', () => ({}));

const router = createRouter({
  history: createWebHistory(process.env.BASE_URL),
  routes,
});

const pinia = createPinia();

describe('LoginPage.vue', () => {
  let wrapper;

  beforeEach(() => {
    wrapper = mount(
      {
        components: { QLayout, QPageContainer, QPage, LoginPage },
        template: `
          <q-layout>
            <q-page-container>
              <q-page>
                <login-page />
              </q-page>
             </q-page-container>
           </q-layout>
         `,
      },
      {
        global: {
          plugins: [Quasar, router, pinia],
        },
      },
    );
  });

  it('Проверяем кнопку и надпись', () => {
    const loginButton = wrapper.find('button');
    expect(loginButton.text()).toContain('Войти');
  });

  it('Проверяем сторку регистрации', () => {
    const emailInput = wrapper.find('input[type="email"]');
    expect(emailInput.attributes('aria-label')).toContain(
      'Введите адрес электронной почты',
    );
  });

  it('Строка ввода пароля', () => {
    const passwordInput = wrapper.find('input[type="password"]');
    expect(passwordInput.attributes('aria-label')).toContain('Введите пароль');
  });

  it('надпись "Вход в Universo"', () => {
    expect(wrapper.find('.text-h6').text()).toContain('Вход в Universo');
  });

  it('надпись "Страница авторизации"', () => {
    expect(wrapper.find('.text-subtitle2').text()).toContain(
      'Страница авторизации',
    );
  });

  it('Наличи регистрации', async () => {
    await router.isReady();
    console.log(wrapper.html());
    const registrationLink = wrapper.findComponent({
      name: 'RouterLink',
      props: { to: { name: 'registration' } },
    });
    expect(registrationLink.exists()).toBeTruthy();

    await registrationLink.trigger('click');

    // Дожидаемся, чтобы Vue Router обработал переход
    await wrapper.vm.$nextTick();
    console.log(router.currentRoute.value.name);

    expect(router.currentRoute.value.name).toBe('start');
  });

  it('проверка текста "Не удается войти?" ', () => {
    console.log(wrapper.html());
    const linkText = wrapper.text();
    expect(linkText.includes('Не удается войти?')).toBeTruthy();
  });
});
