import { describe, it, expect, jest, beforeEach } from '@jest/globals';
import { mount } from '@vue/test-utils';
import { createRouter, createWebHistory } from 'vue-router';
import IndexLayout from '../../../src/layouts/IndexLayout.vue';

//import routes from '../../../src/router/routes';
import {
  Quasar,
  QBtn,
  QHeader,
  QToolbar,
  QToolbarTitle,
  QPageContainer,
} from 'quasar';

//jest.mock('../../../src/boot/apollo.ts', () => ({
// apiUrl: () => ({ proto: 'http:', url: 'http://t34.universo.pro/api/v1.1/' }),
//}));

const LoginView = { template: '<div>Login</div>' }; // минимальный шаблон с html разметкой

const routes = [
  {
    path: '/login', //URL-адрес для маршрута.
    name: 'login',
    component: LoginView, // Компонент, который должен быть отображен, когда активируется этот маршрут
  },
  {
    path: '/', //Корневой маршрут приложения.
    redirect: '/login',
  },
];

const router = createRouter({
  //создания нового экземпляра маршрутизатора.
  history: createWebHistory(),
  routes,
});

jest.spyOn(router, 'push'); //функция из библиотеки Jest для создания моков

describe('IndexLayout', () => {
  let wrapper;

  beforeEach(() => {
    wrapper = mount(IndexLayout, {
      global: {
        plugins: [router, Quasar],
      },
    });
  });

  it('Проверка наличия q-header', () => {
    expect(wrapper.findComponent(QHeader).exists()).toBeTruthy();
  });

  it('Проверка наличия q-toolbar-title и его текста', () => {
    const toolbarTitle = wrapper.findComponent(QToolbarTitle);
    expect(toolbarTitle.exists()).toBeTruthy();
    expect(toolbarTitle.text()).toContain('Universo');
  });

  it(' Кнопка в будущее ', () => {
    const button = wrapper.findComponent(QBtn);
    expect(button.exists()).toBeTruthy();
    expect(button.text()).toContain('В будущее');
  });

  it(' Наличие текста', () => {
    const textContent = wrapper.findComponent(QPageContainer);
    expect(textContent.exists()).toBeTruthy();
    expect(textContent.text()).toContain(
      'Погрузитесь через РВМ Универсо в гипервселенную',
    );
  });
  it('осуществляет переход на страницу входа при нажатии на кнопку "В будущее"', async () => {
    await router.isReady();

    const button = wrapper.findComponent(QBtn);
    await button.trigger('click');

    expect(router.push).toHaveBeenCalledWith({ name: 'login' });
  });
});
