import { defineStore } from 'pinia';
import Phaser from 'phaser';
import { EndlessCanvas } from 'src/apps/spaces-2d/EndlessCanvas';

export const usePhaserStore = defineStore('phaser', {
  state: () => ({
    game: null as Phaser.Game | null,
    sceneReady: false, // состояние для отслеживания готовности сцены
    endlessKanvasScene: null,
    zoomPercentage: '100%',
  }),

  actions: {
    setGame(gameInstance: Phaser.Game): void {
      this.game = gameInstance;
    },
    setScene(scene: EndlessCanvas): void {
      this.endlessKanvasScene = scene;
    },
    setSceneReady(ready: boolean): void {
      this.sceneReady = ready;
    },
    clearPhaserStore() {
      this.$reset();
    },
    setZoomPercentage(text) {
      this.zoomPercentage = text;
    },
  },
});
