import { defineStore } from 'pinia';
import { LocalStorage } from 'quasar';
import { COLOR_BACKGROUND } from 'src/apps/kanbans/Const';

export const useUiStore = defineStore('UI', {
  state: () => ({
    isLoading: 0,
    dark: false,
    loading: 'lazy', //'eager'/'lazy'
    showLoginForm: false,
    localStoredUi: {},
    canvasColor: null,
  }),

  getters: {
    getIsLoading(state) {
      return state.isLoading > 0 ? true : false;
    },
    getImageLoadingMode(state) {
      return state.loading;
    },
    color(state) {
      return state.canvasColor || `#${COLOR_BACKGROUND.toString(16)}`;
    },
  },

  actions: {
    getColor() {
      if (LocalStorage.has('ui_canvas_color')) {
        this.canvasColor =
          LocalStorage.getItem('ui_canvas_color') || COLOR_BACKGROUND;
      }
    },
    setColor(color) {
      this.canvasColor = color;
      LocalStorage.set('ui_canvas_color', color);
    },

    getLocalStoredUi() {
      if (LocalStorage.has('ui_store')) {
        this.localStoredUi = LocalStorage.getItem('ui_store') || {};
      }
    },
    setLocalStoredUi(payload) {
      for (const [key, value] of Object.entries(payload)) {
        this.localStoredUi[key] = value;
      }
      LocalStorage.set('ui_store', this.localStoredUi);
    },
    showIsLoading() {
      this.isLoading++;
    },
    hideIsLoading() {
      this.isLoading > 0 ? this.isLoading-- : (this.isLoading = 0);
    },
  },
});
