import { boot } from 'quasar/wrappers';
import axios from 'axios';
import { getAPIurl } from '../utils';

const api = axios.create({
  baseURL: `${getAPIurl()}jwt/`,
  withCredentials: true,
  xsrfHeaderName: 'X-CSRFTOKEN',
  xsrfCookieName: 'csrftoken',
});

export default boot(({ app }) => {
  // for use inside Vue files (Options API) through this.$axios and this.$api

  app.config.globalProperties.$axios = api;
  // ^ ^ ^ this will allow you to use this.$axios (for Vue Options API form)
  //       so you won't necessarily have to import axios in each vue file
});

export { axios, api };
