// Определите тип для стилей, чтобы облегчить их использование и изменение
interface StyleOptions {
  border?: string;
  width?: string;
  fontStyle?: string;
  font?: string;
  fontFamily?: string;
  fontSize?: number | string;
  backgroundColor?: string;
  color?: string;
  stroke?: string;
  strokeThickness?: number;
  padding?: number;
  align?: string;
  maxLines?: number;
  fixedWidth?: number;
  fixedHeight?: number;
  wordWrap?: boolean;
}

const defaultDOMStyle: StyleOptions = {
  color: '#000',
  font: 'Jura',
  border: '5px dotted tomato',
  width: '400px',
  fontSize: '24px',
};

const defaultPhaserStyle: StyleOptions = {
  color: '#000',
  font: 'Jura',
  fontSize: '24px',
};

export const generateStyle = (options: Partial<StyleOptions> = {}) => {
  const { color, font, border, width, backgroundColor, fontSize } = {
    ...defaultDOMStyle,
    ...options,
  };
  return `
    font-family: ${font};
    width: ${width};
    background-color: ${backgroundColor};
    color: ${color};
    font-size: ${fontSize};
  `;
};

export const phaserTextStyle = (options: Partial<StyleOptions> = {}) => {
  const { color, font, border, width, backgroundColor, fontSize } = {
    ...defaultPhaserStyle,
    ...options,
  };
  return {
    color,
    fontFamily: font,
    backgroundColor,
    fontSize,
  };
};
