import { EndlessCanvas } from '../spaces-2d/EndlessCanvas';

const addStyles = () => {
  const css = `
    .main-div {
      --size: 30px;
      background-color: tomato;
      width: 100px;
      height: 100px;
      position: fixed;
      top: 20px;
      left: 20px;
      pointer-events: none;
      border-radius: calc(var(--size) / 2);
    }
    .draggable-point {
      width: var(--size);
      height: var(--size);
      background-color: transparent;
      border-radius: calc(var(--size) / 2);
      border: solid calc(var(--size) / 8) blue;
      box-sizing: border-box;
      position: absolute;
      pointer-events: initial;
      cursor: pointer;
    }
    .top-left, .top-right, .bottom-left, .bottom-right, .center {
      position: absolute;
    }
    .top-left { top: 0; left: 0; }
    .top-right { top: 0; right: 0; }
    .bottom-left { bottom: 0; left: 0; }
    .bottom-right { bottom: 0; right: 0; }
    .center { top: calc(50% - (var(--size) / 2)); left: calc(50% - (var(--size) / 2)); }
    .dragged { opacity: 50%; }
  `;
  const style = document.createElement('style');
  style.type = 'text/css';
  style.appendChild(document.createTextNode(css));
  document.head.appendChild(style);
};

const createNewDiv = (scene: EndlessCanvas, x: number, y: number) => {
  const newDiv = document.createElement('div');
  newDiv.classList.add('main-div');
  // Для примера, позиционируем новый элемент в точке клика (можно адаптировать под вашу логику)
  newDiv.style.position = 'absolute';
  newDiv.style.left = `${x}px`;
  newDiv.style.top = `${y}px`;
  document.body.appendChild(newDiv);

  // const phaserDiv = scene.add.dom(x, y, 'div');
  // const newDiv = phaserDiv as any as HTMLElement;
  // console.log(newDiv, phaserDiv);
  // phaserDiv.setClassName('main-div');

  const markerArray = [
    'top-left',
    'top-right',
    'bottom-left',
    'bottom-right',
    'center',
  ];

  // Функция для создания обработчика событий
  const createDragHandler = (marker: string, params: StartParams) => {
    const { startX, startY, startWidth, startHeight, startTop, startLeft } =
      params;

    return function onMouseMove(e: MouseEvent) {
      const deltaX = e.clientX - startX;
      const deltaY = e.clientY - startY;
      // Обновление стилей в зависимости от типа маркера
      switch (marker) {
        case 'top-left':
          newDiv.style.width = `${startWidth - deltaX}px`;
          newDiv.style.height = `${startHeight - deltaY}px`;
          newDiv.style.top = `${startTop + deltaY}px`;
          newDiv.style.left = `${startLeft + deltaX}px`;
          break;
        case 'top-right':
          newDiv.style.width = `${startWidth + deltaX}px`;
          newDiv.style.height = `${startHeight - deltaY}px`;
          newDiv.style.top = `${startTop + deltaY}px`;
          break;
        case 'bottom-left':
          newDiv.style.width = `${startWidth - deltaX}px`;
          newDiv.style.height = `${startHeight + deltaY}px`;
          newDiv.style.left = `${startLeft + deltaX}px`;
          break;
        case 'bottom-right':
          newDiv.style.width = `${startWidth + deltaX}px`;
          newDiv.style.height = `${startHeight + deltaY}px`;
          break;
        case 'center':
          newDiv.style.top = `${startTop + deltaY}px`;
          newDiv.style.left = `${startLeft + deltaX}px`;
          break;
      }
    };
  };

  // Упрощение добавления элементов и слушателей событий
  markerArray.forEach((marker) => {
    const element = document.createElement('div');
    element.classList.add('draggable-point', marker);
    newDiv.appendChild(element);

    element.addEventListener('mousedown', (event) => {
      const rect = newDiv.getBoundingClientRect();
      const startParams: StartParams = {
        startX: event.clientX,
        startY: event.clientY,
        startWidth: rect.width,
        startHeight: rect.height,
        startTop: rect.top,
        startLeft: rect.left,
      };

      const onMouseMove = createDragHandler(marker, startParams);

      function onMouseUp() {
        document.removeEventListener('mousemove', onMouseMove);
        document.removeEventListener('mouseup', onMouseUp);
      }

      document.addEventListener('mousemove', onMouseMove);
      document.addEventListener('mouseup', onMouseUp);
      event.preventDefault();
    });
  });
};

// Определение типов для улучшенной читаемости и поддержки
type StartParams = {
  startX: number;
  startY: number;
  startWidth: number;
  startHeight: number;
  startTop: number;
  startLeft: number;
};

export const ResizableWindow = (scene: EndlessCanvas) => {
  addStyles();

  let isListenerActive = false;

  const activateCreation = () => {
    if (!isListenerActive) {
      scene.input.on('pointerdown', (pointer) => {
        const x = pointer.x;
        const y = pointer.y;
        createNewDiv(scene, x, y);
        // Для предотвращения повторного создания, отключаем обработчик после первого вызова
        scene.input.off('pointerdown');
        isListenerActive = false;
      });
      isListenerActive = true;
    }
  };

  // Допустим, это вызов функции, активирующей режим создания div по клику на кнопку UI
  activateCreation();

  // const mainDiv = document.getElementsByClassName('main-div')[0] as HTMLElement;
  // if (!mainDiv) return; // Проверка наличия элемента
};
