import { EndlessCanvas } from '../spaces-2d/EndlessCanvas';
import { generateStyle, phaserTextStyle } from './Styles';

const options = { backgroundColor: '#0f0' };

export default (scene: EndlessCanvas) => {
  scene.input.setDefaultCursor('crosshair');
  let isFirstClick = true;

  const createDOMInput = (
    scene: EndlessCanvas,
    placeholder: string,
    text?: string,
  ) => {
    // Стиль генерируется внутри функции generateStyle без необходимости передачи параметров
    const style = generateStyle(options);
    const content = text
      ? `<input type="text" placeholder="${placeholder}" style="${style}" value="${text}">`
      : `<input type="text" placeholder="${placeholder}" style="${style}">`;
    //@ts-ignore
    const dom = scene.add.dom().createFromHTML(content);
    const el = dom.node.firstChild as HTMLInputElement;
    el.addEventListener('blur', () => {
      createPhaserGameObject(dom, el.value); // Передаем текст напрямую
    });
    return dom;
  };

  const createPhaserGameObject = (domObject, text: string) => {
    // Стиль для Phaser объекта также генерируется без явной передачи параметров
    const textStyle = phaserTextStyle(options);
    const textObject = scene.add.text(
      domObject.x,
      domObject.y,
      text,
      textStyle,
    );
    textObject.setOrigin(0, 0);
    textObject.setFixedSize(0, 36);
    // textObject.setFontSize(textStyle.fontSize);
    // textObject.setFont(textStyle.font);
    textObject.setInteractive();
    textObject.on('pointerdown', () => {
      const el = createDOMInput(scene, 'Введите текст...', text);
      el.setPosition(domObject.x, domObject.y);
      el.setOrigin(0, 0);
      textObject.destroy();
    });
    domObject.destroy();
  };

  const createInputField = (pointer) => {
    const el = createDOMInput(scene, 'Введите текст...');
    el.setOrigin(0, 0);
    el.setPosition(pointer.worldX, pointer.worldY);
  };

  const onCanvasClick = (pointer) => {
    if (isFirstClick) {
      isFirstClick = false;
      return;
    }
    createInputField(pointer);
    scene.input.setDefaultCursor('default');
    scene.input.off('pointerdown', onCanvasClick);
  };

  scene.input.on('pointerdown', onCanvasClick);

  const onEscKey = () => {
    scene.input.setDefaultCursor('default');
    scene.input.keyboard.off('keydown-ESC', onEscKey);
    scene.input.off('pointerdown', onCanvasClick);
  };

  scene.input.keyboard.on('keydown-ESC', onEscKey);
};
