//@ts-nocheck
import { GameObjects } from 'phaser';
import { EndlessCanvas } from './EndlessCanvas';
import { updateZoomPercentage } from './zoomButtonsAndOther';

export default (scene: EndlessCanvas) => {
  let minX = Number.MAX_SAFE_INTEGER;
  let maxX = Number.MIN_SAFE_INTEGER;
  let minY = Number.MAX_SAFE_INTEGER;
  let maxY = Number.MIN_SAFE_INTEGER;

  interface PhaserChildren extends GameObject {
    x: number;
    y: number;
    width: number;
    height: number;
  }
  scene.children.each((c: PhaserChildren) => {
    minX = Math.min(c.x - c.width / 2, minX);
    minY = Math.min(c.y - c.height / 2, minY);
    maxX = Math.max(c.x + c.width / 2, maxX);
    maxY = Math.max(c.y + c.height / 2, maxY);
  });

  // find the bounds of all the content
  let bounds = {
    x: minX,
    y: minY,
    w: maxX - minX,
    h: maxY - minY,
  };
  const PADDING = 50;

  // what percentage of our canvas does the content take
  let percW = scene.cameras.main.width / (bounds.w + PADDING);
  let percH = scene.cameras.main.height / (bounds.h + PADDING);
  let newZoom = Math.min(percW, percH);
  scene.cameras.main.setZoom(newZoom);
  updateZoomPercentage(scene);
  scene.cameras.main.pan(
    bounds.x - PADDING / 2 + (bounds.w + PADDING) / 2,
    bounds.y - PADDING / 2 + (bounds.h + PADDING) / 2,
    200,
  );
};
