﻿/* АЛГОРИТМ
При каждом шаге в роме инвертируетса без повторов определённое количество случайных инструкцый BEQ и BNE, а инструкцыы предыдущево шага инвертируютса
обратно. После проверки так всех инструкцый начинаетса новый цыкл, в котором количество инвертируемых за шаг инструкцый уменьшаетса в два раза,
при этом инструкцыы выбираютса заново случайно.
	реализацыя в этом коде:
Из рома собираютса инструкцыы BEQ и BNE, этот список перемешываетса, и по нему от начала до конца шагает окно, внутри себя инвертирующее инструкцыы
друг в друга в роме и возвращая обратно после себя. При достижении конца списка окно возвращаетса на начало и укорачиваетса в два раза (+остаток
от деления для максимизацыы охвата инструкцый в конце списка), а инструкцыы перемешываютса, штобы разрушыть их камбинацыы, ведущие к багам игры.

Каждый шаг пользователь выбирает их трёх пунктов:
1 гличи    мешают увидеть, што нужное изменение есть/отсутствует - окно сдвигаетса вперёд
2 гличи не мешают увидеть, што нужное изменение отсутствует - удаляютса инструкцыы внутри окна, окно сдвигаетса вперёд
3 гличи не мешают увидеть, што нужное изменение есть - удаляютса инструкцыы вне окна, внутри окна начинаетса поиск делением пополам */


//#define ОТЛАДКА_ИНТРФЭЙСА //ром не будет изменятса, а данные - сохранятса и удалятса

#define _CRT_SECURE_NO_WARNINGS //иначе ругаетса на небезопасные функцыы

#include <windows.h>
#include <vector>
#include <iostream>
#include <conio.h>   //_getwch
#include <Shlwapi.h> //PathFindFileNameA
#pragma comment(lib, "Shlwapi.lib")

//обновление на фоне
#include <thread>
#include <winhttp.h>
#pragma comment(lib, "winhttp.lib")



//ПРОГРАМА
#define ВЕРСИЯ_ПРОГРАМЫ 3
void обновление_програмы(const std::wstring &хост, const std::wstring &путь_до_папки);
#define СИГНАТУРА_ФАЙЛА_ОБНОВЛЕНИЯ 'RG'
struct заголовок_обновления{
	USHORT сигнатура;
	USHORT номер_версии;};
//после заголовка идёт текст обновления до конца файла
bool уже_скачиваетса = false; //для гонки потоков - скачивает только опередившый
#define СИГНАТУРА_EXE   'ZM'
#define ИМЯ_НОВОВО_EXE  L"[new]"
#define ИМЯ_СТАРОВО_EXE L"[old]"

HWND hwnd = GetConsoleWindow();
#define	loop while(true)
#define КАК(x) *(x*)&



//ФАЙЛЫ
#define ПУТЬ_ДО_ФАЙЛА путь[1]
bool подготовка_к_поиску(std::wstring путь_до_файла);
std::wstring ром_закинут_в_окно(); //зависает в ожыдании если ничево не "нажато" до вызова. Возвращает пустую строку, если было што-то нажато
std::wstring имя_рома;
size_t размер_рома;
//поиск
void поиск_кандидатов_на_инструкцыы_NES();
bool это_валидная_инструкцыя_NES(unsigned char образец);
void поиск_кандидатов_на_инструкцыы_SMD();
bool это_валидная_инструкцыя_SMD(unsigned short образец);
void восстановление_инструкцый_в_окне();
//сохранение
bool WINAPI ConsoleHandler(DWORD signal); //для действий при закрытии консоли, даётса 5 секунд. exit() пропускает эти действия
#define ВКЛ_ДЕЙСТВИЯ_ПОСЛЕ_ЗАКРЫТИЯ  SetConsoleCtrlHandler((PHANDLER_ROUTINE)ConsoleHandler, true)
#define ВЫКЛ_ДЕЙСТВИЯ_ПОСЛЕ_ЗАКРЫТИЯ SetConsoleCtrlHandler((PHANDLER_ROUTINE)ConsoleHandler, false)
#define ИМЯ_ФАЙЛА_СОХРАНЕНИЯ L"[поиск на паузе]"
#define ВЕРСИЯ_ФОРМАТА '3IGR'
void сохранение_поиска_в_файл();
bool загрузка_поиска_из_файла();
	#ifdef ОТЛАДКА_ИНТРФЭЙСА
bool файл_сохранения_отсутствует = false;
	#endif



//ПАМЯТЬ
struct ИНСТРУКЦЫЯ{
	int адрес_в_роме;
	int начальное_значение;}; //для скорости, штобы не считывать из рома перед записью в нево
							  //int, т.к. char выравниваетса до int и в файл сохранения попадает и мусор, неудобный для просмотра (и архиватра?)
							  //не битовый массив, штобы можно было экспериментировать и с другими инструкцыями

std::vector<ИНСТРУКЦЫЯ> инструкцыы_на_инвертирование,
						инструкцыы_на_инвертирование_ПРЕД; //для отмены выбора

void перемешывание_всех_инструкцый();
void бэкап_текущево_шага();

UINT окно_начало, окно_начало_ПРЕД; //скользящее окно - надо бы не путать с окном програмы
UINT окно_длина, окно_длина_ПРЕД;
#define НАЧАЛЬНАЯ_ДЛИНА 16 // 1/16 от всех инструкцый, т.к. 1/1, 1/2, 1/4 и 1/8 сильно ломают игру и в начале поиска постоянно пункт 1
UINT шаг;
UCHAR инвертируемый_бит, клавиша_переоткрытия_рома, клавиша_загрузки_сохранения;
#define SEGA 0b00000001
#define NES  0b00100000

bool идёт_локализацыя = false; //если не идёт, значит идёт поиск
void поиск_безуспешен(); //когда на последней инструкцыы нажали 1 или 2



//ИНТРФЭЙС
#define ЕСТЬ_ВВОД _kbhit()
#define СТИРАНИЕ_СТРОКИ printf("\r                                                            \r "); //60 пробелов
void мигающее_сообщение(const char* текст);
void ошыбка(const char* текст);
HANDLE handle = GetStdHandle(STD_OUTPUT_HANDLE); //для каретки консоли
enum ТЕКСТ_ЦВЕТ{ СЕРЫЙ = 8, КРАСНЫЙ = 12, БЕЛЫЙ = 15 };
void отрисовка_главново_экрана();
const char вопрос_о_новом_поиске[] = "Начать новый поиск?";





int wmain(int количество_путей, wchar_t* путь[]){

	setlocale(0, ""); //(бело)русские буквы в консоли
	
	//обновление програмы
	DeleteFileW(ИМЯ_СТАРОВО_EXE);
	DeleteFileW(ИМЯ_НОВОВО_EXE); //недокачанное или по какой-то причине не удалось переименовать	
	std::thread(обновление_програмы, L"hub.mos.ru",  L"/Belarus/ROM_glitcher/-/raw/main/Инвертр/").detach();
	std::thread(обновление_програмы, L"gitverse.ru", L"/api/repos/Belarus/ROM_glitcher/raw/branch/master/Инвертр/").detach();
	



	/* ЗАГРУЗКА РОМА ИЛИ ПОИСКА:

	файл закинут на иконку програмы:
	|
	|	это сохранение, загрузка_поиска_из_файла(){
	|	|
	|	|	ром не закинут, ром из сохранения:
	|	|	|
	|	|	| нет  - новый поиск / ожыдание ево в папке и:
	|	|	| есть - читаем сохранение и продолжаем поиск
	|	|	|
	|	|	ром закинут, начать новый поиск?
	|	|	  да
	|	|	  нет - ром из сохранения:
	|	|		не совпадает - выходим из програмы
	|	|		совпадает    - читаем сохранение и продолжаем поиск}
	|	|
	|	это ром, сохранение:
	|	 нет  - новый поиск
	|	 есть - загрузка_поиска_из_файла()
	|
	файл не закинут, сохранение:
	 нет  - новый поиск
	 есть - загрузка_поиска_из_файла() */


	printf("\n");

	//на иконку програмы закинут один файл
	if(количество_путей == 2){
		if(подготовка_к_поиску(ПУТЬ_ДО_ФАЙЛА) == false)
			while(подготовка_к_поиску(ром_закинут_в_окно()) == false);}
	//не закинут или не один
	else
	if(загрузка_поиска_из_файла() == false)
		while(подготовка_к_поиску(ром_закинут_в_окно()) == false);


	бэкап_текущево_шага();
	if(ВКЛ_ДЕЙСТВИЯ_ПОСЛЕ_ЗАКРЫТИЯ == false)
		ошыбка("Could not set control handler");


	//ПОИСК
	HWND hwnd_эмулятра = 0;
	loop{

		if(IsWindow(hwnd_эмулятра) == false){ //эмулятр не запущен

			SetConsoleCursorPosition(handle, {0, 1});
			SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::БЕЛЫЙ);
			СТИРАНИЕ_СТРОКИ
			printf("Сохранитесь в игре, а в этом окне нажмите Enter");

			DWORD id_текущево_окна;
			GetWindowThreadProcessId(hwnd, &id_текущево_окна);

			//ловим переключение на другое окно
			DWORD id_окна_в_фокусе;
			do{
				GetWindowThreadProcessId(GetForegroundWindow(), &id_окна_в_фокусе);
				Sleep(200);}
			while(id_окна_в_фокусе == id_текущево_окна);

			//убираем случайные нажатия, особенно преждевременный Enter
			while(ЕСТЬ_ВВОД)
				_getwch();

			//получаем дескриптр окна. Понадеемся, што это эмулятр
			loop{
				GetWindowThreadProcessId(GetForegroundWindow(), &id_окна_в_фокусе);
				if(id_окна_в_фокусе == id_текущево_окна)
					if(ЕСТЬ_ВВОД && _getwch() == 0xd){ //Enter
						отрисовка_главново_экрана();
						break;}
					else
						continue;
				hwnd_эмулятра = GetForegroundWindow();
				Sleep(200);}}


		//инвертируем инструкцыы
			#ifndef ОТЛАДКА_ИНТРФЭЙСА
		FILE* rom;
		loop{
			_wfopen_s(&rom, имя_рома.c_str(), L"rb+");
			if(rom)
				break;
			else
				if(MessageBoxA(hwnd, "Ром не доступен для изменения", "", MB_ICONWARNING | MB_OKCANCEL) == IDOK){
					сохранение_поиска_в_файл();
					exit(1);}}
		for(UINT i = окно_начало; i < окно_начало + окно_длина && i < инструкцыы_на_инвертирование.size(); i++){
			fseek(rom, инструкцыы_на_инвертирование[i].адрес_в_роме, SEEK_SET);
			char изменённое = инструкцыы_на_инвертирование[i].начальное_значение ^ инвертируемый_бит;
			fwrite(&изменённое, 1, 1, rom);}
		fclose(rom);
			#endif

		
		//переключаемся на эмулятр и перезагружаем ром с сохранением
			#ifndef ОТЛАДКА_ИНТРФЭЙСА
		ShowWindow(hwnd_эмулятра, SW_RESTORE); //если был свёрнут
		SetForegroundWindow(hwnd_эмулятра);
		Sleep(100);
		keybd_event(клавиша_переоткрытия_рома, 0, 0, 0);
		Sleep(100);
		keybd_event(клавиша_переоткрытия_рома, 0, KEYEVENTF_KEYUP, 0);
		Sleep(100);
		keybd_event(клавиша_загрузки_сохранения, 0, 0, 0);
		Sleep(100);
		keybd_event(клавиша_загрузки_сохранения, 0, KEYEVENTF_KEYUP, 0);
			#endif


		//обновляем интрфэйс:
		//количество инструкцый
		SetConsoleCursorPosition(handle, {13, 1});
		SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::БЕЛЫЙ);
		if(окно_длина == 1)
			printf("      \b\b\b\b\b\b%d", инструкцыы_на_инвертирование.size() - окно_начало);
		else
			printf("      \b\b\b\b\b\b%d", инструкцыы_на_инвертирование.size());
		//количество шагов
		if(!идёт_локализацыя){
			SetConsoleCursorPosition(handle, {5, 3});
			printf("      \b\b\b\b\b\b%d", шаг);} //затираем большое число от предыдущево поиска



		//пользователь нажымает клавишу или вставляет строку (ПКМ или закидывает файл в окно)
		loop{
			UCHAR нажато = _getwch();


			//буфер ввода не опустел
			if(ЕСТЬ_ВВОД){

				//это нажата F-клавиша/стрелка?
				if(нажато == 0 || нажато == 0xe0){
					while(ЕСТЬ_ВВОД) //освобождаем буфер
						_getwch();
					continue;}
 
				//нет, значит это строка
				_ungetwch(нажато); //возвращаем "нажатоe" в буфер
				auto путь_к_рому = ром_закинут_в_окно();
				if(путь_к_рому.empty())
					continue;

				else{
					if(MessageBoxA(hwnd, вопрос_о_новом_поиске, "", MB_OKCANCEL) == IDCANCEL)
						continue;
					восстановление_инструкцый_в_окне();

						#ifdef ОТЛАДКА_ИНТРФЭЙСА
					файл_сохранения_отсутствует = true;
						#else
					DeleteFileW(ИМЯ_ФАЙЛА_СОХРАНЕНИЯ); //если шла локализацыя
						#endif

					ВЫКЛ_ДЕЙСТВИЯ_ПОСЛЕ_ЗАКРЫТИЯ; //иначе далее можно сохранить пустой массив и/или невыбранные клавишы
					
					инструкцыы_на_инвертирование.clear();
					if(подготовка_к_поиску(путь_к_рому) == false)
						while(подготовка_к_поиску(ром_закинут_в_окно()) == false);
					бэкап_текущево_шага();
					
					if(ВКЛ_ДЕЙСТВИЯ_ПОСЛЕ_ЗАКРЫТИЯ == false)
						ошыбка("Could not set control handler");

					отрисовка_главново_экрана();
					hwnd_эмулятра = 0;
					идёт_локализацыя = false;
					шаг = 0;
					break;}}



			//буфер пуст, значит это было нажатие (или вставка одново символа)
			else{
				if(нажато == '1'){

					восстановление_инструкцый_в_окне();
					бэкап_текущево_шага();

					//окно до конца...
					//...не дошло
					if(окно_начало + окно_длина < инструкцыы_на_инвертирование.size())
						окно_начало += окно_длина;

					//...дошло
					else
						if(окно_длина > 1){
							окно_начало = 0;
							if(!идёт_локализацыя)
								окно_длина -= окно_длина / 2;
							else
								окно_длина = инструкцыы_на_инвертирование.size() / 2 + инструкцыы_на_инвертирование.size() % 2;
							перемешывание_всех_инструкцый();}

						else
							поиск_безуспешен();
				
					break;}



				else
				if(нажато == '2'){
			
					восстановление_инструкцый_в_окне();
					бэкап_текущево_шага();
			
					//окно до конца...
					//...не дошло
					if(окно_начало + окно_длина < инструкцыы_на_инвертирование.size()){
						инструкцыы_на_инвертирование.erase(инструкцыы_на_инвертирование.begin() + окно_начало,
														   инструкцыы_на_инвертирование.begin() + окно_начало + окно_длина);
				
						if(идёт_локализацыя) //нужное в другой половине, поэтому сразу делим её
							окно_длина = инструкцыы_на_инвертирование.size() / 2 + инструкцыы_на_инвертирование.size() % 2;}

					//...дошло
					else{
						if(окно_длина > 1 && окно_начало != 0){
							инструкцыы_на_инвертирование.resize(окно_начало);

							окно_начало = 0;
							окно_длина -= окно_длина / 2;

							if(!идёт_локализацыя)
								перемешывание_всех_инструкцый();}

						else
							поиск_безуспешен();}
				
					break;}



				else
				if(нажато == '3'){

					бэкап_текущево_шага();

					if(!идёт_локализацыя){
						идёт_локализацыя = true;
						SetConsoleCursorPosition(handle, {1, 3}); //"Шаг" и количество шагов
						SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::БЕЛЫЙ);
						printf("Локализацыя инструкцыы:");
						сохранение_поиска_в_файл();} //на случай продолжения поиска или ошыбки


					if(окно_длина > 1 && инструкцыы_на_инвертирование.size() > 1){
						восстановление_инструкцый_в_окне();

						инструкцыы_на_инвертирование.erase(инструкцыы_на_инвертирование.begin(),
														   инструкцыы_на_инвертирование.begin() + окно_начало);
						окно_начало = 0;

						if(окно_длина < инструкцыы_на_инвертирование.size())
							инструкцыы_на_инвертирование.resize(окно_длина);
						else
						if(окно_длина > инструкцыы_на_инвертирование.size())
							окно_длина = инструкцыы_на_инвертирование.size();

						окно_длина -= окно_длина / 2;}

					else{
						char сообщение[35];
						sprintf(сообщение, "Адрес нужной инструкцыы: 0x%x", инструкцыы_на_инвертирование[окно_начало].адрес_в_роме);
						if(MessageBoxA(hwnd, сообщение, "", MB_OKCANCEL) == IDCANCEL) //отмена ошыбочново выбора
							continue;

						else
						if(MessageBoxA(hwnd, "Продолжыть поиск?", "", MB_OKCANCEL) == IDCANCEL){
								#ifdef ОТЛАДКА_ИНТРФЭЙСА
							файл_сохранения_отсутствует = true;
								#else
							DeleteFileW(ИМЯ_ФАЙЛА_СОХРАНЕНИЯ);
								#endif
							
							if(инвертируемый_бит == SEGA && MessageBoxA(hwnd, "Исправить контрольную сумму?", "", MB_OKCANCEL) == IDOK){
									#ifndef ОТЛАДКА_ИНТРФЭЙСА
								FILE* rom;
								_wfopen_s(&rom, имя_рома.c_str(), L"rb+");
								fseek(rom, 0x200, SEEK_SET);

								UINT сумма = 0;
								USHORT прибавляемое;
								while(fread(&прибавляемое, 2, 1, rom))
									сумма += std::byteswap(прибавляемое);
								
								fseek(rom, 0x18E, SEEK_SET);
								fwrite(&(сумма = std::byteswap((USHORT)сумма)), 2, 1, rom);
								fclose(rom);
									#endif
								}
							
							exit(0);}
						
						else{
								#ifdef ОТЛАДКА_ИНТРФЭЙСА
							exit(0); //потому што сохранение не создано и грузить нечево
								#endif

							//убираем найденную инструкцыю из поиска, штобы далее не затрагивалась
							int адрес_инструкцыы_на_удаление = инструкцыы_на_инвертирование.front().адрес_в_роме;
							имя_рома.clear(); //"ром не закинут", иначе загрузка далее предложыт новый поиск
							загрузка_поиска_из_файла();

							for(int i = окно_начало; i < окно_начало + окно_длина && i < инструкцыы_на_инвертирование.size(); i++)
								if(инструкцыы_на_инвертирование[i].адрес_в_роме == адрес_инструкцыы_на_удаление){
									инструкцыы_на_инвертирование.erase(инструкцыы_на_инвертирование.begin() + i);
									break;}
							окно_длина--;
							бэкап_текущево_шага();

							отрисовка_главново_экрана();
							идёт_локализацыя = false;
							шаг--;
							break;}}
				
					break;}}};

		шаг++;};}



void обновление_програмы(const std::wstring &хост, const std::wstring &путь_до_папки){

	//скачиваем в память файл с версией програмы
	//если номер версии выше текущей, то скачиваем exe

	//код далее сделан с помощью нейросети - я ещё не изучал програмирование сетей или этот исходник уже устаревшый

	auto hSession = WinHttpOpen(L"Glitcher Updater", 0, 0, 0, 0);
	if(hSession){
		WinHttpSetTimeouts(hSession, 5000, 10000, 10000, 10000);
	
		auto hConnect = WinHttpConnect(hSession, хост.c_str(), 443, 0);
		if(hConnect){
			
			auto hRequest = WinHttpOpenRequest(hConnect, L"GET", (путь_до_папки + L"версия").c_str(), 0, 0, 0, WINHTTP_FLAG_SECURE);
			if(hRequest && WinHttpSendRequest(hRequest, 0, 0, 0, 0, 0, 0) && WinHttpReceiveResponse(hRequest, 0)){

				BYTE буфер_для_скачанново[0x1000]; //текст обновления не должен превышать этот размер (иначе обрежетса?)
				DWORD байтов_скачано;

				if(WinHttpReadData(hRequest, буфер_для_скачанново, sizeof(буфер_для_скачанново), &байтов_скачано) && байтов_скачано > 0 &&
				   GetLastError() == 0 &&
				   (КАК(заголовок_обновления)буфер_для_скачанново).сигнатура  ==  std::byteswap((short) СИГНАТУРА_ФАЙЛА_ОБНОВЛЕНИЯ) &&
				   (КАК(заголовок_обновления)буфер_для_скачанново).номер_версии > std::byteswap((short) ВЕРСИЯ_ПРОГРАМЫ)){
					WinHttpCloseHandle(hRequest);
					hRequest = 0;
					
					std::string текст_обновления((char*)буфер_для_скачанново + sizeof(заголовок_обновления), байтов_скачано - sizeof(заголовок_обновления));
					
					if((hRequest = WinHttpOpenRequest(hConnect, L"GET", (путь_до_папки + L"Инвертр.exe").c_str(), 0, 0, 0, WINHTTP_FLAG_SECURE)) &&
						WinHttpSendRequest(hRequest, 0, 0, 0, 0, 0, 0) && WinHttpReceiveResponse(hRequest, 0)){

						if(WinHttpReadData(hRequest, буфер_для_скачанново, sizeof(буфер_для_скачанново), &байтов_скачано) && байтов_скачано > 0 &&
							КАК(short)буфер_для_скачанново == СИГНАТУРА_EXE &&
							!уже_скачиваетса){
							уже_скачиваетса = true;

							SetConsoleCursorPosition(handle, {1, 11});
							SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::КРАСНЫЙ);
							СТИРАНИЕ_СТРОКИ //на случай, если опередившый поток не смог скачать полностью и остался ево текст
							printf("Скачивание обновления...");

							FILE* file;
							_wfopen_s(&file, ИМЯ_НОВОВО_EXE, L"wb");
							do{fwrite(&буфер_для_скачанново, 1, байтов_скачано, file);}
							while(WinHttpReadData(hRequest, буфер_для_скачанново, sizeof(буфер_для_скачанново), &байтов_скачано) && байтов_скачано > 0);
							fclose(file);

							if(GetLastError()){
								уже_скачиваетса = false;
								DeleteFileW(ИМЯ_НОВОВО_EXE);
								SetConsoleCursorPosition(handle, {1, 11});
								SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::КРАСНЫЙ);
								printf("Скачивание обновления прервано");}
							
							else{
								//получаем имя програмы (пользователь мог её переименовать)
								wchar_t путь_до_програмы[MAX_PATH];
								GetModuleFileNameW(NULL, путь_до_програмы, MAX_PATH);
								std::wstring имя_програмы = PathFindFileNameW(путь_до_програмы);
								
								MoveFileW(имя_програмы.c_str(), ИМЯ_СТАРОВО_EXE);
								MoveFileW(ИМЯ_НОВОВО_EXE, имя_програмы.c_str());

								SetConsoleCursorPosition(handle, {1, 11});
								SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::КРАСНЫЙ);
								if(GetLastError()){
									MoveFileW(ИМЯ_СТАРОВО_EXE, имя_програмы.c_str());
									printf("Ошыбка переименования обновления");}
								else{
									printf("Програма обновлена - перезапустите\n");
									printf("%s", текст_обновления.c_str());}}}}}}

			WinHttpCloseHandle(hRequest);}
		WinHttpCloseHandle(hConnect);}
	WinHttpCloseHandle(hSession);}



std::wstring ром_закинут_в_окно(){
	
	if(ЕСТЬ_ВВОД == false){ //буфер ввода пуст
		SetConsoleCursorPosition(handle, {0, 1});
		SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::БЕЛЫЙ);
		СТИРАНИЕ_СТРОКИ
		printf("Закиньте ром в это окно");}

	//тут зависание на _getwch() в ожыдании ввода, если буфер пуст
	std::wstring путь_до_файла;
	do{путь_до_файла.push_back(_getwch());}
	while(ЕСТЬ_ВВОД);
			
	if(путь_до_файла.size() < 4) //путь не может быть короче C:/F
		путь_до_файла.clear();

	else
	if(путь_до_файла.front() == '"' && путь_до_файла.back() == '"'){ //Windows окружает путь кавычками, если в нём есть пробелы
		путь_до_файла.erase(путь_до_файла.begin());
		//если в строке несколько путей, то укорачиваем её до первово
		путь_до_файла.resize(путь_до_файла.find_first_of(L'"'));}

	else{
		int двоеточий = std::count(путь_до_файла.begin(), путь_до_файла.end(), L':');
		if(двоеточий == 0) //это не путь
			путь_до_файла.clear();
		else
		if(двоеточий > 1){ //в строке несколько путей - укорачиваем её до первово
			auto символов_до_двоеточия = путь_до_файла.find_first_of(L':');
			путь_до_файла.resize(путь_до_файла.find_first_of(L':', символов_до_двоеточия + 1) //перепрыгнули первое двоеточие
																 - символов_до_двоеточия);}}  //убираем ещё и букву перед ним, или што там
																							  //(ожыдаетса, што пути пришли с одново места)
		return путь_до_файла;}



bool подготовка_к_поиску(std::wstring путь_до_файла){

	/* ЭТАПЫ:
	-проверка файла по полученному пути
	-загрузка сохранения или поиск кандидатов на инструкцыы и назначение F-клавиш
	-отрисовка интрфэйса */

	if(путь_до_файла.empty()) //штобы при нажатии клавиш не показывались сообщения ниже
		return false;

	if(GetFileAttributesW(путь_до_файла.c_str()) == INVALID_FILE_ATTRIBUTES){
		мигающее_сообщение("Некоректный путь или проблема с файлом");
		return false;}
	if(GetFileAttributesW(путь_до_файла.c_str()) & FILE_ATTRIBUTE_DIRECTORY){
		мигающее_сообщение("Закинута папка");
		return false;}


	std::wstring путь_до_програмы;
	путь_до_програмы.resize(MAX_PATH);
	GetModuleFileNameW(NULL, путь_до_програмы.data(), MAX_PATH);

	if(int длина_пути  = PathFindFileNameW(путь_до_програмы.c_str()) - путь_до_програмы.c_str();
		   длина_пути != PathFindFileNameW(путь_до_файла.c_str())    - путь_до_файла.c_str() ||
		   std::wmemcmp(путь_до_програмы.c_str(), путь_до_файла.c_str(), длина_пути) != 0){

		мигающее_сообщение("Файл должен быть в папке с програмой");
		//при передаче пути через параметры (закидывание на иконку) меняетса рабочая папка - возвращаем:
		путь_до_програмы.resize(путь_до_програмы.find_last_of(L"\\/"));
		SetCurrentDirectoryW(путь_до_програмы.c_str());
		return false;}
	

	std::wstring имя_файла = PathFindFileNameW(путь_до_файла.c_str());
	if(имя_файла == ИМЯ_ФАЙЛА_СОХРАНЕНИЯ){
		if(загрузка_поиска_из_файла() == false){ //сохранение есть (оно ведь и закинуто сейчас), но вернулся false - значит закинут ром в окно
			while(подготовка_к_поиску(ром_закинут_в_окно()) == false);
			return true;}}

	else{
		имя_рома = имя_файла;
		SetConsoleTitleW(имя_рома.c_str());

		if(загрузка_поиска_из_файла() == false){ //начинаем новый поиск
			FILE* file;
			_wfopen_s(&file, имя_рома.c_str(), L"rb");

			fseek(file, 0, SEEK_END);
			размер_рома = ftell(file);
			if(размер_рома == 0){
				fclose(file);
				мигающее_сообщение("Файл пуст");
				return false;}

			int сигнатура;
			fseek(file, 0, SEEK_SET);
			fread(&сигнатура, 4, 1, file);

			SetConsoleCursorPosition(handle, {1, 1});
			SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::БЕЛЫЙ);
			СТИРАНИЕ_СТРОКИ
			printf("Чтение рома...");

			if(сигнатура == '\x1ASEN'){
				fclose(file);
				поиск_кандидатов_на_инструкцыы_NES();
				инвертируемый_бит = NES;}

			else{
				fseek(file, 0x100, SEEK_SET);
				fread(&сигнатура, 4, 1, file);

				if(сигнатура == 'AGES'){
					fclose(file);
					поиск_кандидатов_на_инструкцыы_SMD();
					инвертируемый_бит = SEGA;}

				else{
					fclose(file);
					мигающее_сообщение("Ром неизвестново фармата");
					return false;}}


			перемешывание_всех_инструкцый();
			окно_начало = 0;
			окно_длина  = инструкцыы_на_инвертирование.size() / НАЧАЛЬНАЯ_ДЛИНА + инструкцыы_на_инвертирование.size() % НАЧАЛЬНАЯ_ДЛИНА;
			шаг			= 1;


			SetConsoleCursorPosition(handle, {1, 1});
			SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::БЕЛЫЙ);
			СТИРАНИЕ_СТРОКИ
			printf("Выберите клавишу F1...F12, переоткрывающую в эмулятре ром");

			клавиша_переоткрытия_рома   = 0;
			клавиша_загрузки_сохранения = 0;

			while(клавиша_загрузки_сохранения == 0){

				for(int к = 0x70; к < 0x7c; к++) //F-клавишы
					if(GetAsyncKeyState(к) & 0x8000){

						if(к == 0x7a){ //F11 переключает окно на полный экран, возвращаем
							keybd_event(к, 0, 0, 0);
							Sleep(100);
							keybd_event(к, 0, KEYEVENTF_KEYUP, 0);}

						if(клавиша_переоткрытия_рома == 0){
							клавиша_переоткрытия_рома = к;
							SetConsoleCursorPosition(handle, {1, 1});
							SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::БЕЛЫЙ);
							СТИРАНИЕ_СТРОКИ
							printf("Выберите клавишу F1...F12, загружающую сохранение");
							while(GetAsyncKeyState(к) & 0x8000)
								Sleep(100);}
						else
							клавиша_загрузки_сохранения = к;
						break;}

				Sleep(100);}}}
	
	return true;}



void поиск_кандидатов_на_инструкцыы_NES(){

	инструкцыы_на_инвертирование.reserve(20000);

	FILE* rom;
	_wfopen_s(&rom, имя_рома.c_str(), L"rb");
	fseek(rom, 0x10, SEEK_SET); //пропускаем заголовок рома
	UCHAR первый_байт;
	
	while(fread(&первый_байт, 1, 1, rom))
		if(первый_байт == 0xf0 || первый_байт == 0xd0){ //BEQ или BNE

			char смещение;
			if(fread(&смещение, 1, 1, rom) == false) //конец рома
				break;

			if(смещение == 0 || смещение == -2) //указывает после инструкцыы или до
				continue;

			size_t адрес_прыжка = ftell(rom) + смещение;
			auto пазицыя_для_прадалжения = ftell(rom) - 1; //проверяем каждый байт рома, даже если получаютса перекрытия

			char следующий_байт;
			if(fread(&следующий_байт, 1, 1, rom) == false) //конец рома
				break;
			if(это_валидная_инструкцыя_NES(следующий_байт) == false){
				fseek(rom, пазицыя_для_прадалжения, SEEK_SET);
				continue;}

			//если инструкцыя прыгает не на инструкцыю, то это не инструкцыя
			if(адрес_прыжка < 0x10 ||           //указывает в заголовок рома или
			   адрес_прыжка > размер_рома - 1){ //вне рома
				fseek(rom, пазицыя_для_прадалжения, SEEK_SET);
				continue;}
	
			fseek(rom, адрес_прыжка, SEEK_SET);
			char прочитанное_по_адресу;
			fread(&прочитанное_по_адресу, 1, 1, rom);
			if(это_валидная_инструкцыя_NES(прочитанное_по_адресу) == false){
				fseek(rom, пазицыя_для_прадалжения, SEEK_SET);
				continue;}			

			//всё ок, сохраняем
			инструкцыы_на_инвертирование.push_back( ИНСТРУКЦЫЯ{ пазицыя_для_прадалжения - 1, первый_байт } );
			fseek(rom, пазицыя_для_прадалжения, SEEK_SET);}
	
	fclose(rom);
	
	if(инструкцыы_на_инвертирование.empty())
		ошыбка("Инструкцыы не найдены");
	
	инструкцыы_на_инвертирование.shrink_to_fit();}



bool это_валидная_инструкцыя_NES(unsigned char образец){

	//массив из 256 битов (всех вариантов байта) - пустоты и инструкцыы с их параметрами
	static unsigned char bool_валидность_варианта[] = {
		0xc6, 0xe6, 0xc6, 0xc6, 0xce, 0xee, 0xc6, 0xc6,
		0xc6, 0xee, 0xc6, 0xc6, 0xc6, 0xee, 0xc6, 0xc6,
		0x4e, 0xae, 0xce, 0xe4, 0xee, 0xee, 0xce, 0xee,
		0xce, 0xee, 0xc6, 0xc6, 0xce, 0xee, 0xc6, 0xc6};

	return bool_валидность_варианта[образец / 8] & 0b10000000 >> образец % 8	?	true : false;}



void поиск_кандидатов_на_инструкцыы_SMD(){

	инструкцыы_на_инвертирование.reserve(20000);

	FILE* rom;
	_wfopen_s(&rom, имя_рома.c_str(), L"rb");
	fseek(rom, 0x200, SEEK_SET); //пропускаем заголовок рома
	char первый_байт;
	
	while(fread(&первый_байт, 1, 1, rom))
	
		if(первый_байт != 0x66 && первый_байт != 0x67) //BEQ и BNE
			fseek(rom, 1, SEEK_CUR); //инструкцыы только по чётным адресам
	
		else{
			char второй_байт;
			fread(&второй_байт, 1, 1, rom);
			if(второй_байт % 2) //нечётный - это не смещение и не длинная форма
				continue;
	
			short смещение;
	
			if(второй_байт == 0){ //длинная форма инструкцыы, далее должны идти два байта смещения
				if(fread(&смещение, 2, 1, rom) == false) //конец рома
					break;
	
				if(смещение == 0) //указывает на свою середину
					continue;
	
				смещение = std::byteswap(смещение); //x86 считывает байты переставленными
				if(смещение % 2 || смещение == -2)  //нечётное или указывает на себя
					continue;
	
				short следующие_2_байта;
				if(fread(&следующие_2_байта, 2, 1, rom) == false) //конец рома
					break;
				fseek(rom, -4, SEEK_CUR); //у длинной формы смещение тоже от двух байт инструкцыы
	
				if(это_валидная_инструкцыя_SMD(следующие_2_байта) == false)
					continue;}
	
			else{
				if(второй_байт == -2) //указывает на себя
					continue;
	
				смещение = (short)второй_байт;
	
				short следующие_2_байта;
				if(fread(&следующие_2_байта, 2, 1, rom) == false) //конец рома
					break;
				fseek(rom, -2, SEEK_CUR);
	
				if(это_валидная_инструкцыя_SMD(следующие_2_байта) == false)
					continue;}
	
			//адрес прыжка должен быть в пределах рома
			size_t адрес_прыжка = ftell(rom) + смещение;
			if(адрес_прыжка < 0x200 ||         //указывает в заголовок рома или
			   адрес_прыжка > размер_рома - 2) //вне рома
				continue;
	
			//если инструкцыя прыгает не на инструкцыю, то это не инструкцыя
			auto текущая_пазицыя = ftell(rom);
	
			fseek(rom, адрес_прыжка, SEEK_SET);
			short прочитанное_по_адресу;
			fread(&прочитанное_по_адресу, 2, 1, rom);
	
			fseek(rom, текущая_пазицыя, SEEK_SET);
	
			if(это_валидная_инструкцыя_SMD(прочитанное_по_адресу) == false)
				continue;
	
			//всё ок, сохраняем
			инструкцыы_на_инвертирование.push_back( ИНСТРУКЦЫЯ{ ftell(rom) - 2, первый_байт } );}
			//при длинной форме текущая пазицыя будет в середине инструкцыы. Это для ситуацыы типа "66 00 67 02" (не длинный BEQ,
			//а два байта данных и короткий BNE), штобы сохранить оба варианта
			//ситуацыя типа "66 00 66 00 66 00" не обрабатываетса, понадеемся на проверку валидности инструкцыы и перемешывание
	
	fclose(rom);
	
	if(инструкцыы_на_инвертирование.empty())
		ошыбка("Инструкцыы не найдены");
	
	инструкцыы_на_инвертирование.shrink_to_fit();}



void восстановление_инструкцый_в_окне(){
	FILE* rom;
	loop{
		_wfopen_s(&rom, имя_рома.c_str(), L"rb+");
		if(rom)
			break;
		else
			if(MessageBoxA(hwnd, "Ром не доступен для восстановления", "", MB_ICONWARNING | MB_OKCANCEL) == IDOK)
				return;}
	for(UINT i = окно_начало; i < окно_начало + окно_длина && i < инструкцыы_на_инвертирование.size(); i++){
		fseek(rom, инструкцыы_на_инвертирование[i].адрес_в_роме, SEEK_SET);
		char изменённое = инструкцыы_на_инвертирование[i].начальное_значение;
			#ifndef ОТЛАДКА_ИНТРФЭЙСА
		fwrite(&изменённое, 1, 1, rom);
			#endif
	}
	fclose(rom);}



bool WINAPI ConsoleHandler(DWORD signal){

	if(signal == CTRL_CLOSE_EVENT){

		восстановление_инструкцый_в_окне();

		if(!идёт_локализацыя)
			сохранение_поиска_в_файл();

		return true;}

	return false;}



void сохранение_поиска_в_файл(){

		#ifdef ОТЛАДКА_ИНТРФЭЙСА
	файл_сохранения_отсутствует = false;
	return;
		#endif

	//сохраняем как предыдущий шаг, если он есть
	if(инструкцыы_на_инвертирование.size() != инструкцыы_на_инвертирование_ПРЕД.size() ||
	   окно_начало != окно_начало_ПРЕД || окно_длина != окно_длина_ПРЕД)
		шаг--;

	FILE* file;
	_wfopen_s(&file, ИМЯ_ФАЙЛА_СОХРАНЕНИЯ, L"wb");
	int записываемое;
	fwrite(&(записываемое = ВЕРСИЯ_ФОРМАТА), 4, 1, file);

	fwrite(&(записываемое = имя_рома.size()), 4, 1, file);
	fwrite(имя_рома.data(), sizeof(*имя_рома.data()), записываемое, file);
		
	fwrite(&(записываемое = инструкцыы_на_инвертирование_ПРЕД.size()), 4, 1, file);
	fwrite(инструкцыы_на_инвертирование_ПРЕД.data(), sizeof(*инструкцыы_на_инвертирование_ПРЕД.data()), записываемое, file);
		
	fwrite(&окно_начало_ПРЕД,  sizeof(окно_начало_ПРЕД),  1, file);
	fwrite(&окно_длина_ПРЕД,   sizeof(окно_длина_ПРЕД),   1, file);
	fwrite(&шаг,               sizeof(шаг),               1, file);

	fwrite(&инвертируемый_бит, sizeof(инвертируемый_бит), 1, file);

	fwrite(&клавиша_переоткрытия_рома,   sizeof(клавиша_переоткрытия_рома),   1, file);
	fwrite(&клавиша_загрузки_сохранения, sizeof(клавиша_загрузки_сохранения), 1, file);
	fclose(file);}



bool загрузка_поиска_из_файла(){

		#ifdef ОТЛАДКА_ИНТРФЭЙСА
	if(файл_сохранения_отсутствует)
		return false;
		#endif

	FILE* file;
	_wfopen_s(&file, ИМЯ_ФАЙЛА_СОХРАНЕНИЯ, L"rb");
	if(!file)
		return false;
	
	else{
		fseek(file, 0, SEEK_END);
		if(ftell(file) == 0)
			ошыбка("Файл сохранения пуст");
		rewind(file);

		int прочитанное;
		fread(&прочитанное, 4, 1, file);
		if(прочитанное != ВЕРСИЯ_ФОРМАТА)
			ошыбка("Файл сохранения неизвестново фармата");

		else{
			//ром не был закинут
			if(имя_рома.empty()){
				fread(&прочитанное, 4, 1, file);
				имя_рома.resize(прочитанное);
				fread(имя_рома.data(), sizeof(*имя_рома.data()), прочитанное, file);
				SetConsoleTitleW(имя_рома.c_str());
				

				while(GetFileAttributesW(имя_рома.c_str()) == INVALID_FILE_ATTRIBUTES){
					мигающее_сообщение("Закиньте этот ром в папку или другой ром в это окно");

					//закинут новый ром?
					if(ЕСТЬ_ВВОД){
						UCHAR нажато = _getwch();
						if(ЕСТЬ_ВВОД){ //буфер ввода не опустел

							//далее не используетса "ром_закинут_в_окно" - он ждёт снаружы, штобы мог вернуть адрес. Отсюда это не сделать
						
							//это нажата F-клавиша/стрелка?
							if(нажато == 0 || нажато == 0xe0)
								while(ЕСТЬ_ВВОД) //освобождаем буфер
									_getwch();
							else{
								//нет, значит это вставка строки
								_ungetwch(нажато); //возвращаем "нажатоe" в буфер
								if(MessageBoxA(hwnd, вопрос_о_новом_поиске, "", MB_OKCANCEL) == IDCANCEL){
									while(ЕСТЬ_ВВОД)
										_getwch();
									continue;}
					
									#ifdef ОТЛАДКА_ИНТРФЭЙСА
								файл_сохранения_отсутствует = true;
									#else
								DeleteFileW(ИМЯ_ФАЙЛА_СОХРАНЕНИЯ); //если шла локализацыя
									#endif
								return false;}}}}}

			//ром был закинут
			else{
				std::wstring имя_рома_из_файла;

				fread(&прочитанное, 4, 1, file);
				имя_рома_из_файла.resize(прочитанное);
				fread(имя_рома_из_файла.data(), sizeof(*имя_рома_из_файла.data()), прочитанное, file);

				if(MessageBoxA(hwnd, вопрос_о_новом_поиске, "", MB_ICONWARNING | MB_OKCANCEL) == IDOK){
					fclose(file);
						#ifdef ОТЛАДКА_ИНТРФЭЙСА
					файл_сохранения_отсутствует = true;
						#else
					DeleteFileW(ИМЯ_ФАЙЛА_СОХРАНЕНИЯ);
						#endif
					return false;}

				else
					if(имя_рома_из_файла != имя_рома)
						exit(0);}


			//читаем сохранённое
			fread(&прочитанное, 4, 1, file);
			инструкцыы_на_инвертирование.resize(прочитанное);
			fread(инструкцыы_на_инвертирование.data(), sizeof(*инструкцыы_на_инвертирование.data()), прочитанное, file);
		
			fread(&окно_начало, sizeof(окно_начало), 1, file);
			fread(&окно_длина,  sizeof(окно_длина),  1, file);
			fread(&шаг,         sizeof(шаг),         1, file);

			fread(&инвертируемый_бит, sizeof(инвертируемый_бит), 1, file);

			fread(&клавиша_переоткрытия_рома,   sizeof(клавиша_переоткрытия_рома),   1, file);
			fread(&клавиша_загрузки_сохранения, sizeof(клавиша_загрузки_сохранения), 1, file);

			fclose(file);
				#ifdef ОТЛАДКА_ИНТРФЭЙСА
			файл_сохранения_отсутствует = true;
				#else
			DeleteFileW(ИМЯ_ФАЙЛА_СОХРАНЕНИЯ);
				#endif
			return true;}}}



void перемешывание_всех_инструкцый(){ //не используетса std::shuffle, т.к. для нево нужно много лишних строк
	for(UINT i = 0; i < инструкцыы_на_инвертирование.size(); i++)
		std::swap(инструкцыы_на_инвертирование[i], инструкцыы_на_инвертирование[rand() % инструкцыы_на_инвертирование.size()]);}



void бэкап_текущево_шага(){
	инструкцыы_на_инвертирование_ПРЕД = инструкцыы_на_инвертирование;
	окно_начало_ПРЕД = окно_начало;
	окно_длина_ПРЕД  = окно_длина;}



void поиск_безуспешен(){

	char сообщение[31];

	if(идёт_локализацыя)
		sprintf(сообщение, "Ошыбка програмы? Сообщите мне");
	else
		sprintf(сообщение, "Инструкцыя не найдена");

	if(MessageBoxA(hwnd, сообщение, "", MB_OKCANCEL) == IDCANCEL){ //отмена ошыбочново выбора
		шаг--;
		return;}
	else
		exit(0);}



void мигающее_сообщение(const char* текст){ //прерываетса, если што-то нажать/ввести
	SetConsoleCursorPosition(handle, {0, 1});
	SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::КРАСНЫЙ);

	//мигаем
	char раз = 3;
	while(раз--){
		СТИРАНИЕ_СТРОКИ

		if(ЕСТЬ_ВВОД)
			goto выходим;
		Sleep(300);

		printf("%s", текст);

		if(ЕСТЬ_ВВОД)
			goto выходим;
		Sleep(300);}

	//не мигаем
	раз = 8;
	while(раз--){
		if(ЕСТЬ_ВВОД)
			goto выходим;
		Sleep(300);}

	выходим:
	СТИРАНИЕ_СТРОКИ
	return;}



void ошыбка(const char* текст){
	SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::КРАСНЫЙ);
	printf(" %s\n\n ", текст);
	system("pause");
	exit(1);}


void отрисовка_главново_экрана(){

	SetConsoleCursorPosition(handle, {0, 1});
	SetConsoleTextAttribute(handle, ТЕКСТ_ЦВЕТ::СЕРЫЙ);
	СТИРАНИЕ_СТРОКИ
	printf("Инструкцый:\n\n");

	printf(" Шаг                    \n"); //затираем "Локализацыя инструкцыы:"
	printf(" Нужное изменение есть?\n");
	printf(" 1  Баг мешает узнать\n");
	printf(" 2  Нет\n");
	printf(" 3  Да\n\n");

	printf(" Для отмены последнево выбора перезапустите програму\n");
	printf(" Для новово поиска закиньте ром в это окно");}




bool это_валидная_инструкцыя_SMD(unsigned short образец){

	//массив из 65 536 битов (всех вариантов двух байтов) - пустоты и инструкцыы с их параметрами
	static unsigned char bool_валидность_варианта[] = {0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xf0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xf0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xf0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xf0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xf0, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xf0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xff, 0xff, 0x00, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf7, 0x00, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xf0, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0xff, 0x00, 0x00, 0xff, 0xff, 0xf0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xaa, 0xa8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xf8, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xc0, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0xff, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00, 0x00}; 
	
	образец = std::byteswap(образец); //оптимизацыя скорости - штобы избавитса от этово можно переставить биты в массиве заранее
	return bool_валидность_варианта[образец / 8] & 0b10000000 >> образец % 8	?	true : false;}